/*
 * Decompiled with CFR 0.152.
 */
package io.milton.mail.pop;

import io.milton.mail.MailResourceFactory;
import io.milton.mail.Message;
import io.milton.mail.pop.AuthState;
import io.milton.mail.pop.GreetingState;
import io.milton.mail.pop.PopState;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopSession {
    private static final Logger log = LoggerFactory.getLogger(PopSession.class);
    UUID sessionId = UUID.randomUUID();
    PopState state;
    AuthState auth;
    final MailResourceFactory resourceFactory;
    Collection<Message> messageResources;
    ArrayList<Message> messages;

    PopSession(IoSession session, MailResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
        this.state = new GreetingState(this);
        this.state.enter(session, this);
    }

    void messageReceived(IoSession session, Object msg) {
        try {
            log.info("messageReceived: state: " + this.state.getClass() + " msg:" + msg);
            String sMsg = (String)msg;
            String[] arr = sMsg.split(" ");
            String sCmd = arr[0];
            sCmd = sCmd.toLowerCase();
            Method m = this.state.getClass().getMethod(sCmd, IoSession.class, PopSession.class, arr.getClass());
            if (m == null) {
                throw new RuntimeException("un-handled command: " + sCmd);
            }
            m.invoke((Object)this.state, session, this, arr);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    void transitionTo(IoSession session, PopState newState) {
        this.state.exit(session, this);
        this.state = newState;
        this.state.enter(session, this);
        log.info("new state: " + this.state.getClass());
    }

    void reply(IoSession session, String msg) {
        log.info("reply: " + msg);
        log.info("..length: " + msg.length());
        session.write((Object)(msg + '\r'));
    }

    void replyMultiline(IoSession session, String content) {
        session.write((Object)(content + "\n"));
    }
}

