/*
 * Decompiled with CFR 0.152.
 */
package io.milton.mail;

import io.milton.mail.pop.PopServer;
import io.milton.mail.receive.SmtpServer;
import io.milton.mail.send.MailSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailServer {
    private static final Logger log = LoggerFactory.getLogger(MailServer.class);
    private MailSender mailSender;
    private SmtpServer smtpServer;
    private SmtpServer msaSmtpServer;
    private PopServer popServer;

    public MailServer(MailSender mailSender, SmtpServer smtpServer, PopServer popServer, SmtpServer msaSmtpServer) {
        this.mailSender = mailSender;
        this.smtpServer = smtpServer;
        this.popServer = popServer;
        this.msaSmtpServer = msaSmtpServer;
    }

    public void start() {
        log.debug("starting mail servers...");
        if (this.mailSender != null) {
            log.debug("starting mail sender..");
            this.mailSender.start();
        }
        if (this.smtpServer != null) {
            log.debug("starting smtp receiver..");
            this.smtpServer.start();
        }
        if (this.msaSmtpServer != null) {
            log.debug("starting authenticated smtp server..");
            if (this.smtpServer != null && this.smtpServer.getSmtpPort() == this.msaSmtpServer.getSmtpPort()) {
                log.error("The Authenticated SMTP server is configured to run on the same port as the un-authenticated server: " + this.msaSmtpServer.getSmtpPort() + ". The authenticated one should be on 587 and non-auth on 25. See - http://www.ietf.org/rfc/rfc2476.txt");
            } else {
                this.msaSmtpServer.start();
            }
        }
        if (this.popServer != null) {
            log.debug("starting pop server..");
            this.popServer.start();
        }
        log.debug("...done loading mail servers");
    }

    public void stop() {
        log.debug("stopping mail server components...");
        if (this.mailSender != null) {
            try {
                this.mailSender.stop();
            }
            catch (Throwable e) {
                log.debug("exception stopping mailsender: " + e.getMessage());
            }
        }
        if (this.smtpServer != null) {
            try {
                this.smtpServer.stop();
            }
            catch (Throwable e) {
                log.debug("exception stopping smtp server: " + e.getMessage());
            }
        }
        if (this.msaSmtpServer != null) {
            try {
                this.msaSmtpServer.stop();
            }
            catch (Throwable e) {
                log.debug("exception stopping msa server: " + e.getMessage());
            }
        }
        if (this.popServer != null) {
            try {
                this.popServer.stop();
            }
            catch (Throwable e) {
                log.debug("exception stopping pop server: " + e.getMessage());
            }
        }
        log.debug("...done stopping mail servers");
    }

    public MailSender getMailSender() {
        return this.mailSender;
    }

    public PopServer getPopServer() {
        return this.popServer;
    }

    public SmtpServer getSmtpServer() {
        return this.smtpServer;
    }

    public void setMailSender(MailSender mailSender) {
        this.mailSender = mailSender;
    }

    public void setPopServer(PopServer popServer) {
        this.popServer = popServer;
    }

    public void setSmtpServer(SmtpServer smtpServer) {
        this.smtpServer = smtpServer;
    }
}

