/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.xml.util;

import java.io.InputStream;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ClassPathEntityResolver
implements EntityResolver {
    private Class root;
    private String name;
    private String prefix;

    public ClassPathEntityResolver(String DTDName, Class root) {
        this.name = DTDName;
        this.root = root;
    }

    public ClassPathEntityResolver(Class root, String DTDPrefix) {
        this.prefix = DTDPrefix;
        this.root = root;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (this.name != null && systemId.endsWith(this.name)) {
            InputStream in = this.root.getResourceAsStream(this.name);
            if (in == null) {
                throw new SAXException(systemId + " not found");
            }
            return new InputSource(in);
        }
        if (this.prefix != null && systemId.startsWith(this.prefix)) {
            String postfix = systemId.substring(this.prefix.length());
            InputStream in = this.root.getResourceAsStream(postfix);
            if (in == null) {
                throw new SAXException(systemId + " not found");
            }
            return new InputSource(in);
        }
        return null;
    }
}

