/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.plugins;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.security.Principal;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.security.auth.x500.X500Principal;
import org.dcache.auth.LoginNamePrincipal;
import org.dcache.auth.UserNamePrincipal;
import org.dcache.auth.util.GSSUtils;
import org.dcache.auth.util.X509Utils;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.plugins.GPlazmaAuthenticationPlugin;
import org.dcache.gplazma.plugins.IMapCredentialsClient;
import org.dcache.gplazma.plugins.PrivilegeDelegate;
import org.dcache.gplazma.util.Preconditions;
import org.dcache.util.NetworkUtils;
import org.glite.voms.PKIVerifier;
import org.glite.voms.VOMSAttribute;
import org.glite.voms.VOMSValidator;
import org.glite.voms.ac.ACValidator;
import org.glite.voms.ac.AttributeCertificate;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.ietf.jgss.GSSException;
import org.opensciencegrid.authz.xacml.common.LocalId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class XACMLPlugin
implements GPlazmaAuthenticationPlugin {
    static final String CADIR = "gplazma.vomsdir.ca";
    static final String VOMSDIR = "gplazma.vomsdir.dir";
    static final String VATTR_VALIDATE = "gplazma.voms.validate";
    static final String ILLEGAL_CACHE_SIZE = "cache size must be non-zero positive integer; was: ";
    static final String ILLEGAL_CACHE_LIFE = "cache life must be positive integer; was: ";
    static final String DENIED_MESSAGE = "Permission Denied: No XACML mapping retrieved for extensions ";
    static final String HOST_CREDENTIAL_ERROR = "Could not load host globus credentials ";
    static final String SERVICE_URL_PROPERTY = "gplazma.xacml.service.url";
    static final String CLIENT_TYPE_PROPERTY = "gplazma.xacml.client.type";
    static final String SERVICE_KEY = "gplazma.xacml.hostkey";
    static final String SERVICE_CERT = "gplazma.xacml.hostcert";
    static final String SERVICE_CA = "gplazma.xacml.ca";
    static final String CACHE_LIFETIME = "gplazma.xacml.cachelife.secs";
    static final String CACHE_SIZE = "gplazma.xacml.cache.maxsize";
    private static final Logger logger = LoggerFactory.getLogger(XACMLPlugin.class);
    private static final String DEFAULT_CACHE_LIFETIME = "30";
    private static final String DEFAULT_CACHE_SIZE = "1024";
    private LoadingCache<VomsExtensions, LocalId> _localIdCache;
    private final PKIVerifier _pkiVerifier;
    private boolean _vomsAttrValidate;
    private final String _mappingServiceURL;
    private final Properties _properties;
    private Class<? extends PrivilegeDelegate> _clientType;
    private String _targetServiceName;
    private String _targetServiceIssuer;
    private String _resourceDNSHostName;

    public XACMLPlugin(Properties properties) throws ClassNotFoundException, GSSException, SocketException, CertificateException, CRLException, IOException {
        this._properties = properties;
        String pki = properties.getProperty(VATTR_VALIDATE);
        if (pki != null) {
            this._vomsAttrValidate = Boolean.parseBoolean(pki);
        }
        String caDir = properties.getProperty(CADIR);
        String vomsDir = properties.getProperty(VOMSDIR);
        this._pkiVerifier = GSSUtils.getPkiVerifier((String)vomsDir, (String)caDir, (Map)MDC.getCopyOfContextMap());
        System.setProperty("sslCAFiles", properties.getProperty(SERVICE_CA) + "/*.0");
        System.setProperty("sslCertfile", properties.getProperty(SERVICE_CERT));
        System.setProperty("sslKey", properties.getProperty(SERVICE_KEY));
        this._mappingServiceURL = properties.getProperty(SERVICE_URL_PROPERTY);
        com.google.common.base.Preconditions.checkArgument((this._mappingServiceURL != null ? 1 : 0) != 0, (Object)"Undefined property: gplazma.xacml.service.url");
        this.setClientType(properties.getProperty(CLIENT_TYPE_PROPERTY));
        this.configureTargetServiceInfo();
        this.configureResourceDNSHostName();
        this.configureCache();
        logger.debug("XACML plugin now loaded for URL {}", (Object)this._mappingServiceURL);
    }

    public void authenticate(Set<Object> publicCredentials, Set<Object> privateCredentials, Set<Principal> identifiedPrincipals) throws AuthenticationException {
        Preconditions.checkAuthentication((!Iterables.any(identifiedPrincipals, (Predicate)Predicates.instanceOf(UserNamePrincipal.class)) ? 1 : 0) != 0, (String)"username already defined");
        VOMSValidator validator = new VOMSValidator(null, new ACValidator(this._pkiVerifier));
        LinkedHashSet<VomsExtensions> extensions = new LinkedHashSet<VomsExtensions>();
        for (Object credential : publicCredentials) {
            if (!(credential instanceof X509Certificate[])) continue;
            this.extractExtensionsFromChain((X509Certificate[])credential, extensions, validator);
        }
        if (extensions.isEmpty()) {
            for (Principal principal : identifiedPrincipals) {
                VomsExtensions vomsExtensions = new VomsExtensions(principal.getName(), null, null, null, null, null, false);
                logger.debug(" {} authenticate, adding voms extensions = {}", (Object)this, (Object)vomsExtensions);
                extensions.add(vomsExtensions);
            }
        }
        logger.debug("VOMS extensions found: {}", extensions);
        Preconditions.checkAuthentication((!extensions.isEmpty() ? 1 : 0) != 0, (String)"no subjects found to map");
        Principal login = (Principal)Iterables.find(identifiedPrincipals, (Predicate)Predicates.instanceOf(LoginNamePrincipal.class), null);
        String userName = this.getMappingFor(login, extensions);
        Preconditions.checkAuthentication((userName != null ? 1 : 0) != 0, (String)("no mapping for: " + extensions));
        identifiedPrincipals.add((Principal)new UserNamePrincipal(userName));
    }

    private void configureCache() throws IllegalArgumentException {
        int expiry = Integer.parseInt(this._properties.getProperty(CACHE_LIFETIME, DEFAULT_CACHE_LIFETIME));
        if (expiry < 0) {
            throw new IllegalArgumentException(ILLEGAL_CACHE_LIFE + expiry);
        }
        int size = Integer.parseInt(this._properties.getProperty(CACHE_SIZE, DEFAULT_CACHE_SIZE));
        if (size < 1) {
            throw new IllegalArgumentException(ILLEGAL_CACHE_SIZE + size);
        }
        this._localIdCache = CacheBuilder.newBuilder().expireAfterAccess((long)expiry, TimeUnit.SECONDS).maximumSize((long)size).softValues().build((CacheLoader)new XACMLFetcher());
    }

    private void configureResourceDNSHostName() throws SocketException {
        ArrayList addressList = NetworkUtils.getLocalAddresses();
        if (addressList.isEmpty()) {
            return;
        }
        addressList = new ArrayList(addressList);
        Collections.sort(addressList, NetworkUtils.getExternalInternalSorter());
        this._resourceDNSHostName = ((InetAddress)addressList.get(0)).getCanonicalHostName();
    }

    private void configureTargetServiceInfo() throws GSSException {
        GlobusCredential serviceCredential;
        try {
            serviceCredential = new GlobusCredential(this._properties.getProperty(SERVICE_CERT), this._properties.getProperty(SERVICE_KEY));
        }
        catch (GlobusCredentialException gce) {
            throw new GSSException(13, 0, HOST_CREDENTIAL_ERROR + gce.toString());
        }
        this._targetServiceName = serviceCredential.getIdentity();
        this._targetServiceIssuer = X509Utils.toGlobusDN((String)serviceCredential.getIssuer(), (boolean)true);
    }

    private void extractExtensionsFromChain(X509Certificate[] chain, Set<VomsExtensions> extensionsSet, VOMSValidator validator) throws AuthenticationException {
        if (chain == null) {
            return;
        }
        String proxySubject = X509Utils.getSubjectFromX509Chain((X509Certificate[])chain, (boolean)false);
        String proxySubjectIssuer = X509Utils.getSubjectX509Issuer((X509Certificate[])chain, (boolean)true);
        String vomsSubject = X509Utils.getSubjectX509Issuer((X509Certificate[])chain, (boolean)false);
        if (this._vomsAttrValidate) {
            validator.setClientChain(chain).validate();
        } else {
            validator.setClientChain(chain).parse();
        }
        List vomsAttributes = validator.getVOMSAttributes();
        boolean primary = true;
        if (vomsAttributes.isEmpty()) {
            VomsExtensions vomsExtensions = new VomsExtensions(proxySubject, proxySubjectIssuer, null, vomsSubject, null, null, primary);
            logger.debug(" {} authenticate, adding voms extensions = {}", (Object)this, (Object)vomsExtensions);
            extensionsSet.add(vomsExtensions);
        } else {
            for (VOMSAttribute vomsAttr : vomsAttributes) {
                AttributeCertificate ac = vomsAttr.getAC();
                X500Principal x500 = ac == null ? null : ac.getIssuer();
                List fqans = vomsAttr.getFullyQualifiedAttributes();
                if (fqans.isEmpty()) {
                    VomsExtensions vomsExtensions = new VomsExtensions(proxySubject, proxySubjectIssuer, vomsAttr.getVO(), vomsSubject, x500, null, primary);
                    primary = false;
                    logger.debug(" {} authenticate, adding voms extensions = {}", (Object)this, (Object)vomsExtensions);
                    extensionsSet.add(vomsExtensions);
                    continue;
                }
                for (Object fqan : vomsAttr.getFullyQualifiedAttributes()) {
                    VomsExtensions vomsExtensions = new VomsExtensions(proxySubject, proxySubjectIssuer, vomsAttr.getVO(), vomsSubject, x500, String.valueOf(fqan), primary);
                    primary = false;
                    logger.debug(" {} authenticate, adding voms extensions = {}", (Object)this, (Object)vomsExtensions);
                    extensionsSet.add(vomsExtensions);
                }
            }
        }
    }

    private String getMappingFor(Principal login, Set<VomsExtensions> extensionSet) {
        for (VomsExtensions extensions : extensionSet) {
            try {
                LocalId localId = (LocalId)this._localIdCache.get((Object)extensions);
                String name = localId.getUserName();
                if (name == null || login != null && !login.getName().equals(name)) continue;
                logger.debug("getMappingFor {} = {}", (Object)extensions, (Object)name);
                return name;
            }
            catch (ExecutionException t) {
                logger.debug("could not find mapping for {}; continuing ...", (Object)extensions);
            }
        }
        logger.debug("no XACML mappings found for {}, {}", (Object)login, extensionSet);
        return null;
    }

    private IMapCredentialsClient newClient() throws AuthenticationException {
        try {
            IMapCredentialsClient newInstance = this._clientType.newInstance();
            return newInstance;
        }
        catch (IllegalAccessException | InstantiationException t) {
            throw new AuthenticationException(t.getMessage(), (Throwable)t);
        }
    }

    private void setClientType(String property) throws ClassNotFoundException {
        this._clientType = property == null || property.length() == 0 ? PrivilegeDelegate.class : Class.forName(property, true, Thread.currentThread().getContextClassLoader()).asSubclass(PrivilegeDelegate.class);
    }

    private class XACMLFetcher
    extends CacheLoader<VomsExtensions, LocalId> {
        private XACMLFetcher() {
        }

        public LocalId load(VomsExtensions key) throws AuthenticationException {
            IMapCredentialsClient xacmlClient = XACMLPlugin.this.newClient();
            xacmlClient.configure(XACMLPlugin.this._properties);
            xacmlClient.setX509Subject(key._x509Subject);
            xacmlClient.setX509SubjectIssuer(key._x509SubjectIssuer);
            xacmlClient.setFqan(key._fqan);
            xacmlClient.setVO(key._vo);
            xacmlClient.setVOMSSigningSubject(key._vomsSubject);
            xacmlClient.setVOMSSigningIssuer(key._vomsSubjectIssuer);
            xacmlClient.setResourceType("http://authz-interop.org/xacml/resource/resource-type/se");
            xacmlClient.setResourceDNSHostName(XACMLPlugin.this._resourceDNSHostName);
            xacmlClient.setResourceX509ID(XACMLPlugin.this._targetServiceName);
            xacmlClient.setResourceX509Issuer(XACMLPlugin.this._targetServiceIssuer);
            xacmlClient.setRequestedaction("http://authz-interop.org/xacml/action/action-type/access");
            LocalId localId = xacmlClient.mapCredentials(XACMLPlugin.this._mappingServiceURL);
            com.google.common.base.Preconditions.checkArgument((localId != null ? 1 : 0) != 0, (Object)(XACMLPlugin.DENIED_MESSAGE + key));
            logger.debug("mapping service {} returned localId {} for {} ", new Object[]{XACMLPlugin.this._mappingServiceURL, localId, key});
            return localId;
        }
    }

    private static class VomsExtensions {
        private String _x509Subject;
        private String _x509SubjectIssuer;
        private String _fqan;
        private boolean _primary;
        private String _vo;
        private String _vomsSubject;
        private String _vomsSubjectIssuer;

        private VomsExtensions(String proxySubject, String proxySubjectIssuer, String vo, String vomsSubject, X500Principal x500, String fqan, boolean primary) {
            this._x509Subject = proxySubject;
            this._x509SubjectIssuer = proxySubjectIssuer;
            this._vo = vo;
            this._vomsSubject = vomsSubject;
            if (x500 != null) {
                this._vomsSubjectIssuer = X509Utils.toGlobusDN((String)x500.toString(), (boolean)true);
            }
            this._fqan = fqan;
            this._primary = primary;
        }

        public boolean equals(Object object) {
            if (!(object instanceof VomsExtensions)) {
                return false;
            }
            return this.toString().equals(object.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return VomsExtensions.class.getSimpleName() + "[X509Subject='" + this._x509Subject + "', X509SubjectIssuer='" + this._x509SubjectIssuer + "', fqan='" + this._fqan + "', primary=" + this._primary + ", VO='" + this._vo + "', VOMSSubject='" + this._vomsSubject + "', VOMSSubjectIssuer='" + this._vomsSubjectIssuer + "']";
        }
    }
}

