/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.argv;

import java.util.ArrayList;
import java.util.List;
import org.freehep.util.argv.MissingArgumentException;
import org.freehep.util.argv.Option;

public class MultiStringOption
implements Option {
    private String flag;
    private String shortCut;
    private String name;
    private String desc;
    private List value = new ArrayList();

    public MultiStringOption(String flag, String name, String description) {
        this(flag, null, name, description);
    }

    public MultiStringOption(String flag, String shortCut, String name, String description) {
        this.flag = flag;
        this.shortCut = shortCut;
        this.name = name;
        this.desc = description;
    }

    public List getValue() {
        return this.value;
    }

    @Override
    public int parse(List values) throws MissingArgumentException {
        if (values.get(0).equals(this.flag) || values.get(0).equals(this.shortCut)) {
            if (values.size() == 1) {
                throw new MissingArgumentException(this.flag + ": expects '" + this.name + "' of type <string>");
            }
            this.value.add((String)values.get(1));
            return 2;
        }
        return 0;
    }

    @Override
    public String getOption() {
        StringBuffer s = new StringBuffer(this.flag);
        s.append(" <");
        s.append(this.name);
        s.append(">");
        return s.toString();
    }

    @Override
    public String getUsage() {
        return this.desc;
    }
}

