/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.argv;

import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.freehep.util.argv.ArgumentFormatException;
import org.freehep.util.argv.BailOutException;
import org.freehep.util.argv.BooleanOption;
import org.freehep.util.argv.ListParameter;
import org.freehep.util.argv.MissingArgumentException;
import org.freehep.util.argv.NumberOption;
import org.freehep.util.argv.Option;
import org.freehep.util.argv.Parameter;
import org.freehep.util.argv.StringOption;

public class ArgumentParser {
    private List options = new LinkedList();
    private List parameters = new LinkedList();
    private String name;

    public ArgumentParser(String name) {
        this.name = name;
    }

    public void add(Option opt) {
        this.options.add(opt);
    }

    public void add(Parameter param) {
        this.parameters.add(param);
    }

    public void printUsage(OutputStream out) {
        PrintStream p = new PrintStream(out);
        p.print("Usage: " + this.name);
        if (!this.options.isEmpty()) {
            p.print(" [-options]");
        }
        if (!this.parameters.isEmpty()) {
            for (Parameter param : this.parameters) {
                p.print(" ");
                p.print(param.getName());
            }
            p.println();
            p.println();
            p.println("parameters:");
            Iterator i2 = this.parameters.iterator();
            int w = 0;
            while (i2.hasNext()) {
                Parameter param = (Parameter)i2.next();
                w = Math.max(w, param.getName().length());
            }
            for (Parameter param : this.parameters) {
                p.print("  ");
                p.print(this.pad(param.getName(), w));
                p.print("   ");
                p.println(param.getUsage());
            }
        } else {
            p.println();
        }
        if (!this.options.isEmpty()) {
            p.println();
            p.println("options:");
            Iterator i1 = this.options.iterator();
            int w = 0;
            while (i1.hasNext()) {
                Option opt = (Option)i1.next();
                w = Math.max(w, opt.getOption().length());
            }
            for (Option opt : this.options) {
                p.print("  ");
                p.print(this.pad(opt.getOption(), w));
                p.print("   ");
                p.println(opt.getUsage());
            }
        }
    }

    public List parse(String[] args) throws MissingArgumentException, ArgumentFormatException {
        List<String> list = Arrays.asList(args);
        return this.parse(list);
    }

    public List parse(List args) throws MissingArgumentException, ArgumentFormatException {
        List extras = new LinkedList();
        try {
            int numArgsConsumed;
            block2: while (!args.isEmpty()) {
                for (Option opt : this.options) {
                    numArgsConsumed = opt.parse(args);
                    if (numArgsConsumed <= 0) continue;
                    args = args.subList(numArgsConsumed, args.size());
                    continue block2;
                }
                extras.add(args.get(0));
                args = args.subList(1, args.size());
            }
            for (Parameter parameter : this.parameters) {
                numArgsConsumed = parameter.parse(extras);
                if (numArgsConsumed <= 0) continue;
                extras = extras.subList(numArgsConsumed, extras.size());
            }
        }
        catch (BailOutException boe) {
            return Collections.EMPTY_LIST;
        }
        return extras;
    }

    private String pad(String s, int w) {
        if (w < s.length()) {
            return s.substring(0, w);
        }
        StringBuffer sb = new StringBuffer(s);
        for (int i = w - s.length(); i > 0; --i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public static void main(String[] ignored) throws MissingArgumentException, ArgumentFormatException {
        String[] empty = new String[]{};
        String[] exact = new String[]{"-string1", "value1", "-n1", "0.0314159e2"};
        String[] extra = new String[]{"-string1", "value1", "-n2", "10", "-bool1", "-string2", "value2"};
        StringOption string1 = new StringOption("-string1", "string1", "");
        StringOption string3 = new StringOption("-string3", "string3", "value3", "");
        BooleanOption bool1 = new BooleanOption("-bool1", "");
        NumberOption n1 = new NumberOption("-n1", "n1", "");
        ArgumentParser parser = new ArgumentParser("ArgumentParser");
        parser.add(string1);
        parser.add(string3);
        parser.add(bool1);
        parser.add(n1);
        System.out.println("Test 01-001: Run arg parser w/ no args");
        parser.parse(empty);
        if (string1.getValue() != null) {
            throw new RuntimeException("Default value for string1 failed");
        }
        if (string3.getValue() != "value3") {
            throw new RuntimeException("Default value for string3 failed");
        }
        if (bool1.getValue()) {
            throw new RuntimeException("Default value for bool1 failed");
        }
        if (n1.getValue() != null) {
            throw new RuntimeException("Default value for n1 failed");
        }
        System.out.println("Test 01-002: Run arg parser w/ args");
        List remaining = parser.parse(exact);
        System.out.println("Test 02-001: Check string1");
        if (!string1.getValue().equals("value1")) {
            throw new RuntimeException("Parsing string1 failed");
        }
        if (string3.getValue() != "value3") {
            throw new RuntimeException("Default value for string3 failed");
        }
        if (bool1.getValue()) {
            throw new RuntimeException("Default value for bool1 failed");
        }
        if (!n1.getValue().equals(new BigDecimal("3.14159"))) {
            throw new RuntimeException("Default value for n1 failed");
        }
        if (!remaining.isEmpty()) {
            throw new RuntimeException("Should be no remaining args");
        }
        System.out.println("Test 01-003: Run arg parser w/ extra args");
        remaining = parser.parse(extra);
        System.out.println("Test 02-001: Check string1");
        if (!string1.getValue().equals("value1")) {
            throw new RuntimeException("Parsing string1 failed");
        }
        System.out.println("Test 02-002: Check bool1");
        if (!bool1.getValue()) {
            throw new RuntimeException("bool1 should have been true");
        }
        System.out.println("Test 02-003: Check remaining args");
        if (!remaining.equals(Arrays.asList("-n2", "10", "-string2", "value2"))) {
            throw new RuntimeException("Remaining args incorrect");
        }
        System.out.println("Test 02-004: Check string3");
        if (!string3.getValue().equals("value3")) {
            throw new RuntimeException("Default for string3 failed");
        }
        System.out.println("Test 3: ListArgument");
        ListParameter lp = new ListParameter("vacuum", "list of vacuums");
        parser.add(lp);
        remaining = parser.parse(extra);
        if (!lp.getValue().equals(Arrays.asList("-n2", "10", "-bool1", "-string2", "value2"))) {
            throw new RuntimeException("List args incorrect");
        }
    }
}

