/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.posix;

import org.dcache.chimera.posix.Acl;
import org.dcache.chimera.posix.AclHandler;
import org.dcache.chimera.posix.UnixAcl;
import org.dcache.chimera.posix.UnixUser;
import org.dcache.chimera.posix.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixPermissionHandler
implements AclHandler {
    private static Logger _log = LoggerFactory.getLogger(UnixPermissionHandler.class);
    private static UnixPermissionHandler HANDLER = new UnixPermissionHandler();

    private UnixPermissionHandler() {
    }

    public static UnixPermissionHandler getInstance() {
        return HANDLER;
    }

    private static boolean inGroup(User user, int group) {
        int userGid = ((UnixUser)user).getGID();
        int[] userGids = ((UnixUser)user).getGIDS();
        boolean inGroup = false;
        if (group == userGid) {
            inGroup = true;
        } else {
            for (int gid : userGids) {
                if (group != gid) continue;
                inGroup = true;
                break;
            }
        }
        return inGroup;
    }

    @Override
    public boolean isAllowed(Acl acl, User user, int requsetedAcl) {
        boolean isAllowed = false;
        int userUid = ((UnixUser)user).getUID();
        if (!(acl instanceof UnixAcl)) {
            return false;
        }
        int resourceUid = ((UnixAcl)acl).getOwner();
        int resourceGid = ((UnixAcl)acl).getGroup();
        int resourcePermissions = ((UnixAcl)acl).getPermission();
        if (_log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("ACL request : ");
            sb.append("user=").append(((UnixUser)user).getUID()).append(":").append(((UnixUser)user).getGID());
            sb.append(" ");
            sb.append("file=").append(resourceUid).append(":").append(resourceGid);
            sb.append(" ");
            sb.append("action=");
            switch (requsetedAcl) {
                case 0: {
                    sb.append("ACL_READ");
                    break;
                }
                case 2: {
                    sb.append("ACL_WRITE");
                    break;
                }
                case 3: {
                    sb.append("ACL_DELETE");
                    break;
                }
                case 4: {
                    sb.append("ACL_LOOKUP");
                    break;
                }
                case 5: {
                    sb.append("ACL_ADMINISTER");
                    break;
                }
                case 6: {
                    sb.append("ACL_INSERT");
                    break;
                }
                case 7: {
                    sb.append("ACL_LOCK");
                    break;
                }
                case 8: {
                    sb.append("ACL_EXECUTE");
                    break;
                }
                default: {
                    sb.append("ACL_UNKNOWN");
                }
            }
            _log.debug(sb.toString());
        }
        block10 : switch (userUid) {
            case 0: {
                isAllowed = true;
                break;
            }
            case -12: {
                isAllowed = false;
                break;
            }
            default: {
                switch (requsetedAcl) {
                    case 0: {
                        if (resourceUid == userUid) {
                            isAllowed = (resourcePermissions & 0x100) == 256;
                            break block10;
                        }
                        if (UnixPermissionHandler.inGroup(user, resourceGid)) {
                            isAllowed = (resourcePermissions & 0x20) == 32;
                            break block10;
                        }
                        isAllowed = (resourcePermissions & 4) == 4;
                        break block10;
                    }
                    case 2: {
                        if (resourceUid == userUid) {
                            isAllowed = (resourcePermissions & 0x80) == 128;
                            break block10;
                        }
                        if (UnixPermissionHandler.inGroup(user, resourceGid)) {
                            isAllowed = (resourcePermissions & 0x10) == 16;
                            break block10;
                        }
                        isAllowed = (resourcePermissions & 2) == 2;
                        break block10;
                    }
                    case 3: {
                        isAllowed = this.isAllowed(acl, user, 2);
                        if ((resourcePermissions & 0x200) != 512) break block10;
                        System.out.println("Sticky bit set!");
                        isAllowed = isAllowed && this.isAllowed(acl, user, 5);
                        break block10;
                    }
                    case 4: {
                        isAllowed = this.isAllowed(acl, user, 0) && this.isAllowed(acl, user, 8);
                        break block10;
                    }
                    case 5: {
                        isAllowed = resourceUid == userUid;
                        break block10;
                    }
                    case 6: {
                        isAllowed = this.isAllowed(acl, user, 2);
                        break block10;
                    }
                    case 7: {
                        isAllowed = true;
                        break block10;
                    }
                    case 8: {
                        isAllowed = resourceUid == userUid ? (resourcePermissions & 0x40) == 64 : (UnixPermissionHandler.inGroup(user, resourceGid) ? (resourcePermissions & 8) == 8 : (resourcePermissions & 1) == 1);
                    }
                }
            }
        }
        _log.debug("IsAllowed: " + isAllowed);
        return isAllowed;
    }
}

