/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.cli;

import com.google.common.io.ByteStreams;
import java.io.InputStream;
import org.dcache.chimera.FileNotFoundHimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.cli.FsFactory;
import org.dcache.chimera.cli.Readtag;

public class Writetag {
    public static void main(String[] args) throws Exception {
        int programArgc = args.length - 5;
        if (programArgc < 2 || programArgc > 3) {
            System.err.println("Usage : " + Readtag.class.getName() + " " + "<jdbcDrv> <jdbcUrl> <dbDialect> <dbUser> <dbPass>" + " <chimera path> <tag> [<data>]");
            System.exit(4);
        }
        try (FileSystemProvider fs = FsFactory.createFileSystem(args);){
            byte[] data;
            FsInode inode = fs.path2inode(args[5]);
            String tag = args[6];
            try {
                fs.statTag(inode, tag);
            }
            catch (FileNotFoundHimeraFsException fnf) {
                fs.createTag(inode, tag);
            }
            byte[] byArray = data = programArgc == 2 ? ByteStreams.toByteArray((InputStream)System.in) : Writetag.newLineTerminated(args[7]).getBytes();
            if (data.length > 0) {
                fs.setTag(inode, tag, data, 0, data.length);
            }
        }
    }

    private static String newLineTerminated(String unknown) {
        return unknown.endsWith("\n") ? unknown : unknown + "\n";
    }
}

