/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.cli;

import java.util.List;
import org.dcache.acl.ACE;
import org.dcache.acl.enums.RsType;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.cli.FsFactory;

public class Getfacl {
    public static void main(String[] args) throws Exception {
        if (args.length < 6) {
            System.err.println("Usage : " + Getfacl.class.getName() + " " + "<jdbcDrv> <jdbcUrl> <dbDialect> <dbUser> <dbPass>" + " <chimera path>");
            System.exit(4);
        }
        try (FileSystemProvider fs = FsFactory.createFileSystem(args);){
            FsInode inode = fs.path2inode(args[5]);
            List<ACE> acl = fs.getACL(inode);
            for (ACE ace : acl) {
                System.out.println(ace.toExtraFormat(inode.isDirectory() ? RsType.DIR : RsType.FILE));
            }
        }
    }
}

