/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.cli;

import com.jolbox.bonecp.BoneCPDataSource;
import javax.sql.DataSource;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.JdbcFs;

public class FsFactory {
    public static final String USAGE = "<jdbcDrv> <jdbcUrl> <dbDialect> <dbUser> <dbPass>";
    public static final int ARGC = 5;

    public static FileSystemProvider createFileSystem(String[] args) throws Exception {
        if (args.length < 5) {
            throw new IllegalArgumentException();
        }
        String jdbcDrv = args[0];
        String jdbcUrl = args[1];
        String dbDialect = args[2];
        String dbUser = args[3];
        String dbPass = args[4];
        Class.forName(jdbcDrv);
        BoneCPDataSource ds = new BoneCPDataSource();
        ds.setJdbcUrl(jdbcUrl);
        ds.setUsername(dbUser);
        ds.setPassword(dbPass);
        ds.setIdleConnectionTestPeriodInMinutes(60L);
        ds.setIdleMaxAgeInMinutes(240L);
        ds.setMaxConnectionsPerPartition(2);
        ds.setMinConnectionsPerPartition(1);
        ds.setPartitionCount(1);
        ds.setAcquireIncrement(1);
        ds.setStatementsCacheSize(100);
        ds.setReleaseHelperThreads(0);
        ds.setDisableConnectionTracking(true);
        ds.setDisableJMX(true);
        ds.setStatisticsEnabled(false);
        return new JdbcFs((DataSource)ds, dbDialect);
    }
}

