/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.cli;

import com.google.common.base.Preconditions;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.cli.FsFactory;

public class Chown {
    private static final int DUMMY_GID_VALUE = -1;
    private static int _uid;
    private static int _gid;

    public static void main(String[] args) throws Exception {
        if (args.length != 7) {
            System.err.println("Usage : " + Chown.class.getName() + " " + "<jdbcDrv> <jdbcUrl> <dbDialect> <dbUser> <dbPass>" + " <chimera path> <uid>[:<gid>]");
            System.exit(4);
        }
        try {
            Chown.parseOwnership(args[6]);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        try (FileSystemProvider fs = FsFactory.createFileSystem(args);){
            FsInode inode = fs.path2inode(args[5]);
            inode.setUID(_uid);
            if (_gid != -1) {
                inode.setGID(_gid);
            }
        }
    }

    private static void parseOwnership(String ownership) {
        int colon = ownership.indexOf(58);
        if (colon == -1) {
            _uid = Chown.parseInteger(ownership);
            _gid = -1;
        } else {
            Preconditions.checkArgument((colon > 0 && colon < ownership.length() - 1 ? 1 : 0) != 0, (Object)"colon must separate two integers");
            _uid = Chown.parseInteger(ownership.substring(0, colon));
            _gid = Chown.parseInteger(ownership.substring(colon + 1));
            Preconditions.checkArgument((_gid >= 0 ? 1 : 0) != 0, (Object)"gid must be 0 or greater");
        }
        Preconditions.checkArgument((_uid >= 0 ? 1 : 0) != 0, (Object)"uid must be 0 or greater");
    }

    private static int parseInteger(String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("only integer values are allowed and \"" + value + "\" is not an integer");
        }
    }
}

