/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.cli;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.cli.FsFactory;
import org.dcache.util.ChecksumType;

public class Checksum {
    private static final ImmutableMap<String, Class<? extends Command>> COMMANDS = new ImmutableMap.Builder().put((Object)"help", HelpCommand.class).put((Object)"list", ListCommand.class).put((Object)"get", GetCommand.class).put((Object)"add", AddCommand.class).put((Object)"delete", DeleteCommand.class).build();
    private static final Class<? extends Command> DEFAULT_COMMAND = HelpCommand.class;

    public static void main(String[] args) throws Exception {
        if (args.length < 6) {
            System.err.println("Usage : " + Checksum.class.getName() + " " + "<jdbcDrv> <jdbcUrl> <dbDialect> <dbUser> <dbPass>" + " <chimera path> [<cmd> [<args>]]");
            System.exit(4);
        }
        try (Command command = Checksum.buildCommand(args);){
            command.run();
        }
    }

    private static Command buildCommand(String[] args) throws Exception {
        Class type = null;
        if (args.length > 6) {
            String name = args[6];
            type = (Class)COMMANDS.get((Object)name.toLowerCase());
        }
        if (type == null) {
            type = DEFAULT_COMMAND;
        }
        Command command = type.newInstance();
        command.init(args);
        return command;
    }

    public static class DeleteCommand
    extends Command {
        public static final String DESCRIPTION = "remove the checksum generated with the specified algorithm";

        @Override
        public void run() throws Exception {
            Preconditions.checkArgument((this._args.length == 1 ? 1 : 0) != 0, (Object)"Need precisely one argument after 'delete', the checksum algorithm");
            ChecksumType type = ChecksumType.getChecksumType((String)this._args[0]);
            FsInode inode = this.getFileInode();
            this._fs.removeInodeChecksum(inode, type.getType());
        }
    }

    public static class AddCommand
    extends Command {
        public static final String DESCRIPTION = "updated file to have an additional checksum value";

        @Override
        public void run() throws Exception {
            Preconditions.checkArgument((this._args.length == 2 ? 1 : 0) != 0, (Object)"need precisely two arguments after 'add'");
            ChecksumType type = ChecksumType.getChecksumType((String)this._args[0]);
            org.dcache.util.Checksum checksum = new org.dcache.util.Checksum(type, this._args[1]);
            FsInode inode = this.getFileInode();
            this._fs.setInodeChecksum(inode, type.getType(), checksum.getValue());
        }
    }

    public static class GetCommand
    extends Command {
        public static final String DESCRIPTION = "prints the value of file's checksum for the given algorithm, if known";

        @Override
        public void run() throws Exception {
            Preconditions.checkArgument((this._args.length == 1 ? 1 : 0) != 0, (Object)"need precisely one argument after 'get'");
            ChecksumType type = ChecksumType.getChecksumType((String)this._args[0]);
            FsInode inode = this.getFileInode();
            String checksum = this._fs.getInodeChecksum(inode, type.getType());
            if (checksum == null) {
                System.out.println("No checksum of type " + type.getName());
            } else {
                System.out.println(checksum);
            }
        }
    }

    public static class ListCommand
    extends Command {
        public static final String DESCRIPTION = "list all checksums for a file";

        @Override
        public void run() throws Exception {
            FsInode inode = this.getFileInode();
            for (ChecksumType type : ChecksumType.values()) {
                String checksum = this._fs.getInodeChecksum(inode, type.getType());
                if (checksum == null) continue;
                System.out.println(type.getName() + ":" + checksum);
            }
        }
    }

    public static class HelpCommand
    extends Command {
        public static final String DESCRIPTION = "provides some help (this information)";

        @Override
        public void run() {
            System.out.println("Format:");
            System.out.println("    checksum <path> <command> [<arguments>]\n");
            int max = 0;
            for (String name : COMMANDS.keySet()) {
                if (name.length() <= max) continue;
                max = name.length();
            }
            System.out.println("Valid commands are:");
            for (Map.Entry entry : COMMANDS.entrySet()) {
                String name = (String)entry.getKey();
                String description = this.getDescription((Class)entry.getValue());
                System.out.println("    " + Strings.padEnd((String)name, (int)max, (char)' ') + " - " + description);
            }
        }

        public String getDescription(Class<? extends Command> command) {
            try {
                return (String)command.getDeclaredField("DESCRIPTION").get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static abstract class Command
    implements Closeable {
        protected FileSystemProvider _fs;
        protected String _path;
        protected String[] _args;

        public void init(String[] args) throws Exception {
            this._fs = FsFactory.createFileSystem(args);
            this._path = args[5];
            this._args = Command.buildCommandArgs(args);
        }

        public FsInode getFileInode() throws ChimeraFsException {
            FsInode inode = this._fs.path2inode(this._path);
            if (inode.isDirectory() || inode.isLink()) {
                throw new IllegalArgumentException("not a file: " + this._path);
            }
            return inode;
        }

        private static String[] buildCommandArgs(String[] args) {
            int count = args.length - 5 - 2;
            String[] commandArgs = new String[count < 0 ? 0 : count];
            if (count > 0) {
                System.arraycopy(args, 7, commandArgs, 0, count);
            }
            return commandArgs;
        }

        @Override
        public void close() throws IOException {
            this._fs.close();
        }

        public abstract void run() throws Exception;
    }
}

