/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsSqlDriver;
import org.dcache.chimera.IOHimeraFsException;
import org.dcache.chimera.posix.Stat;
import org.dcache.commons.util.SqlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PgSQLFsSqlDriver
extends FsSqlDriver {
    private static final Logger _log = LoggerFactory.getLogger(PgSQLFsSqlDriver.class);
    private static final String sqlInode2Path = "SELECT inode2path(?)";
    private static final String sqlPath2Inode = "SELECT path2inode(?, ?)";
    private static final String sqlPath2Inodes = "SELECT ipnfsid,isize,inlink,itype,imode,iuid,igid,iatime,ictime,imtime from path2inodes(?, ?)";
    private static final String sqlCreateEntryInParent = "insert into t_dirs (iparent, iname, ipnfsid)  (select ? as iparent, ? as iname, ? as ipnfsid  where not exists (select 1 from t_dirs where iparent=? and iname=?))";

    protected PgSQLFsSqlDriver() {
        _log.info("Running PostgreSQL specific Driver");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String inode2path(Connection dbConnection, FsInode inode, FsInode startFrom, boolean inclusive) throws SQLException {
        String path = null;
        PreparedStatement ps = null;
        ResultSet result = null;
        try {
            ps = dbConnection.prepareStatement(sqlInode2Path);
            ps.setString(1, inode.toString());
            result = ps.executeQuery();
            if (result.next()) {
                path = result.getString(1);
            }
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(result);
            SqlHelper.tryToClose((PreparedStatement)ps);
            throw throwable;
        }
        SqlHelper.tryToClose((ResultSet)result);
        SqlHelper.tryToClose((PreparedStatement)ps);
        return path;
    }

    private String normalizePath(String path) {
        File file = new File(path);
        ArrayList<String> elements = new ArrayList<String>();
        do {
            String fileName;
            if ((fileName = file.getName()).length() == 0) continue;
            elements.add(fileName);
        } while ((file = file.getParentFile()) != null);
        StringBuilder normalizedPath = new StringBuilder();
        if (!elements.isEmpty()) {
            normalizedPath.append((String)elements.get(elements.size() - 1));
            for (int i = elements.size() - 2; i >= 0; --i) {
                normalizedPath.append('/').append((String)elements.get(i));
            }
        }
        return normalizedPath.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    FsInode path2inode(Connection dbConnection, FsInode root, String path) throws SQLException, IOHimeraFsException {
        ResultSet result;
        PreparedStatement st;
        block4: {
            FsInode fsInode;
            if ((path = this.normalizePath(path)).length() == 0) {
                return root;
            }
            st = null;
            result = null;
            try {
                String id;
                st = dbConnection.prepareStatement(sqlPath2Inode);
                st.setString(1, root.toString());
                st.setString(2, path);
                result = st.executeQuery();
                if (!result.next() || (id = result.getString(1)) == null) break block4;
                fsInode = new FsInode(root.getFs(), id);
            }
            catch (Throwable throwable) {
                SqlHelper.tryToClose(result);
                SqlHelper.tryToClose((PreparedStatement)st);
                throw throwable;
            }
            SqlHelper.tryToClose((ResultSet)result);
            SqlHelper.tryToClose((PreparedStatement)st);
            return fsInode;
        }
        FsInode fsInode = null;
        SqlHelper.tryToClose((ResultSet)result);
        SqlHelper.tryToClose((PreparedStatement)st);
        return fsInode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<FsInode> path2inodes(Connection dbConnection, FsInode root, String path) throws SQLException, IOHimeraFsException {
        if ((path = this.normalizePath(path)).length() == 0) {
            return Collections.singletonList(root);
        }
        ArrayList<FsInode> inodes = new ArrayList<FsInode>();
        PreparedStatement st = null;
        ResultSet result = null;
        try {
            st = dbConnection.prepareStatement(sqlPath2Inodes);
            st.setString(1, root.toString());
            st.setString(2, path);
            result = st.executeQuery();
            while (result.next()) {
                FsInode inode = new FsInode(root.getFs(), result.getString("ipnfsid"));
                Stat stat = new Stat();
                stat.setSize(result.getLong("isize"));
                stat.setATime(result.getTimestamp("iatime").getTime());
                stat.setCTime(result.getTimestamp("ictime").getTime());
                stat.setMTime(result.getTimestamp("imtime").getTime());
                stat.setUid(result.getInt("iuid"));
                stat.setGid(result.getInt("igid"));
                stat.setMode(result.getInt("imode") | result.getInt("itype"));
                stat.setNlink(result.getInt("inlink"));
                stat.setIno((int)inode.id());
                stat.setDev(17);
                inode.setStatCache(stat);
                inodes.add(inode);
            }
        }
        catch (Throwable throwable) {
            SqlHelper.tryToClose(result);
            SqlHelper.tryToClose((PreparedStatement)st);
            throw throwable;
        }
        SqlHelper.tryToClose((ResultSet)result);
        SqlHelper.tryToClose((PreparedStatement)st);
        return inodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void createEntryInParent(Connection dbConnection, FsInode parent, String name, FsInode inode) throws SQLException {
        PreparedStatement stInserIntoParent = null;
        try {
            stInserIntoParent = dbConnection.prepareStatement(sqlCreateEntryInParent);
            stInserIntoParent.setString(1, parent.toString());
            stInserIntoParent.setString(2, name);
            stInserIntoParent.setString(3, inode.toString());
            stInserIntoParent.setString(4, parent.toString());
            stInserIntoParent.setString(5, name);
            int n = stInserIntoParent.executeUpdate();
            if (n == 0) {
                throw new SQLException("Entry already exists", "2300");
            }
        }
        finally {
            SqlHelper.tryToClose((PreparedStatement)stInserIntoParent);
        }
    }

    @Override
    void copyTags(Connection dbConnection, FsInode orign, FsInode destination) throws SQLException {
    }
}

