/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import java.util.UUID;

public class InodeId {
    private InodeId() {
    }

    public static String newID(int fsId) {
        UUID newId = UUID.randomUUID();
        StringBuilder idString = new StringBuilder(36);
        idString.append(InodeId.digits((long)fsId >> 32, 4)).append(InodeId.digits(newId.getMostSignificantBits() >> 32, 8)).append(InodeId.digits(newId.getMostSignificantBits() >> 16, 4)).append(InodeId.digits(newId.getMostSignificantBits(), 4)).append(InodeId.digits(newId.getLeastSignificantBits() >> 48, 4)).append(InodeId.digits(newId.getLeastSignificantBits(), 12));
        return idString.toString().toUpperCase();
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public static byte[] hexStringToByteArray(String id) {
        if (id.length() % 2 != 0) {
            throw new IllegalArgumentException("The string needs to be even-length: " + id);
        }
        int len = id.length() / 2;
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            int charIndex = i * 2;
            int d0 = InodeId.toDigit(id.charAt(charIndex));
            int d1 = InodeId.toDigit(id.charAt(charIndex + 1));
            bytes[i] = (byte)((d0 << 4) + d1);
        }
        return bytes;
    }

    private static int toDigit(char ch) throws NumberFormatException {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new NumberFormatException("illegal character '" + ch + "'");
    }
}

