/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import com.google.common.base.Charsets;
import java.util.Arrays;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsInodeType;
import org.dcache.chimera.posix.Stat;

public class FsInode_PSET
extends FsInode {
    private final String[] _args;

    public FsInode_PSET(FileSystemProvider fs, String id, String[] args) {
        super(fs, id, FsInodeType.PSET);
        this._args = (String[])args.clone();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public int read(long pos, byte[] data, int offset, int len) {
        return -1;
    }

    @Override
    public void setATime(long atime) throws ChimeraFsException {
    }

    @Override
    public void setCTime(long ctime) throws ChimeraFsException {
    }

    @Override
    public void setGID(int gid) throws ChimeraFsException {
    }

    @Override
    public void setMode(int mode) throws ChimeraFsException {
    }

    @Override
    public void setMTime(long mtime) throws ChimeraFsException {
        if (this._args[0].equals("size")) {
            try {
                this._fs.setFileSize(this, Long.parseLong(this._args[1]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            super.setMTime(mtime);
            return;
        }
        if (this._args[0].equals("io")) {
            this._fs.setInodeIo(this, this._args[1].equals("on"));
        }
    }

    @Override
    public void setSize(long size) throws ChimeraFsException {
    }

    @Override
    public void setUID(int uid) throws ChimeraFsException {
    }

    @Override
    public Stat stat() throws ChimeraFsException {
        Stat ret = super.stat();
        ret.setMode(ret.getMode() & 0x1FF | 0x8000);
        ret.setSize(0L);
        if (this._args[0].equals("io")) {
            ret.setUid(0);
            ret.setGid(0);
        }
        return ret;
    }

    @Override
    public byte[] getIdentifier() {
        StringBuilder sb = new StringBuilder();
        for (String arg : this._args) {
            sb.append(arg).append(':');
        }
        return this.byteBase(sb.toString().getBytes(Charsets.UTF_8));
    }

    @Override
    public int write(long pos, byte[] data, int offset, int len) {
        return -1;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FsInode_PSET)) {
            return false;
        }
        return super.equals(o) && Arrays.equals(this._args, ((FsInode_PSET)o)._args);
    }

    @Override
    public int hashCode() {
        return 17;
    }
}

