/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import java.io.File;
import org.dcache.chimera.ChimeraFsException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.FsInodeType;
import org.dcache.chimera.posix.Stat;

public class FsInode_NAMEOF
extends FsInode {
    String _name;

    public FsInode_NAMEOF(FileSystemProvider fs, String id) {
        super(fs, id, FsInodeType.NAMEOF);
    }

    @Override
    public int read(long pos, byte[] data, int offset, int len) {
        byte[] b;
        if (this._name == null) {
            File f;
            try {
                f = new File(this._fs.inode2path(this));
            }
            catch (ChimeraFsException e) {
                return -1;
            }
            this._name = f.getName();
        }
        if (pos > (long)(b = (this._name + "\n").getBytes()).length) {
            return 0;
        }
        int copyLen = Math.min(len, b.length - (int)pos);
        System.arraycopy(b, (int)pos, data, 0, copyLen);
        return copyLen;
    }

    @Override
    public Stat stat() throws ChimeraFsException {
        Stat ret = super.stat();
        ret.setMode(ret.getMode() & 0x1FF | 0x8000);
        if (this._name == null) {
            File f = new File(this._fs.inode2path(this));
            this._name = f.getName();
        }
        ret.setSize(this._name.length() + 1);
        return ret;
    }

    @Override
    public int write(long pos, byte[] data, int offset, int len) {
        return -1;
    }
}

