/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.dcache.chimera.DirectoryStreamB;
import org.dcache.chimera.FsInode;
import org.dcache.chimera.HimeraDirectoryEntry;
import org.dcache.chimera.posix.Stat;
import org.dcache.commons.util.SqlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryStreamImpl
implements DirectoryStreamB<HimeraDirectoryEntry>,
Iterator<HimeraDirectoryEntry> {
    private static final Logger _log = LoggerFactory.getLogger(DirectoryStreamImpl.class);
    private final Connection _con;
    private final PreparedStatement _st;
    private final ResultSet _listResultSet;
    private final FsInode _parent;
    private boolean _hasPendingElement;

    DirectoryStreamImpl(FsInode parent, Connection con, PreparedStatement st, ResultSet result) {
        this._st = st;
        this._con = con;
        this._listResultSet = result;
        this._parent = parent;
        this._hasPendingElement = false;
    }

    @Override
    public Iterator<HimeraDirectoryEntry> iterator() {
        return this;
    }

    @Override
    public void close() throws IOException {
        SqlHelper.tryToClose((ResultSet)this._listResultSet);
        SqlHelper.tryToClose((PreparedStatement)this._st);
        try {
            this._con.close();
        }
        catch (SQLException e) {
            _log.error("failed to close DB connection: " + e.getMessage());
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public boolean hasNext() {
        if (this._hasPendingElement) {
            return true;
        }
        try {
            boolean hasNext = this._listResultSet.next();
            if (hasNext) {
                this._hasPendingElement = true;
            }
            return hasNext;
        }
        catch (SQLException ex) {
            _log.error("failed check for next entry: " + ex.getMessage());
            return false;
        }
    }

    @Override
    public HimeraDirectoryEntry next() {
        try {
            Stat stat = new Stat();
            stat.setSize(this._listResultSet.getLong("isize"));
            stat.setATime(this._listResultSet.getTimestamp("iatime").getTime());
            stat.setCTime(this._listResultSet.getTimestamp("ictime").getTime());
            stat.setMTime(this._listResultSet.getTimestamp("imtime").getTime());
            stat.setUid(this._listResultSet.getInt("iuid"));
            stat.setGid(this._listResultSet.getInt("igid"));
            stat.setMode(this._listResultSet.getInt("imode") | this._listResultSet.getInt("itype"));
            stat.setNlink(this._listResultSet.getInt("inlink"));
            FsInode inode = new FsInode(this._parent.getFs(), this._listResultSet.getString("ipnfsid"));
            inode.setParent(this._parent);
            stat.setIno((int)inode.id());
            stat.setDev(17);
            inode.setStatCache(stat);
            this._hasPendingElement = false;
            return new HimeraDirectoryEntry(this._listResultSet.getString("iname"), inode, stat);
        }
        catch (SQLException e) {
            _log.error("failed to fetch next entry: " + e.getMessage());
            throw new NoSuchElementException("Got SQL exception: " + e.getMessage());
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

