/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.plugins;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dcache.auth.FQANPrincipal;
import org.dcache.auth.util.GSSUtils;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.plugins.GPlazmaAuthenticationPlugin;
import org.dcache.gplazma.util.Preconditions;
import org.glite.voms.PKIVerifier;
import org.glite.voms.VOMSValidator;
import org.glite.voms.ac.ACValidator;
import org.slf4j.MDC;

public class VomsPlugin
implements GPlazmaAuthenticationPlugin {
    private static final String CADIR = "gplazma.vomsdir.ca";
    private static final String VOMSDIR = "gplazma.vomsdir.dir";
    private final PKIVerifier _pkiVerifier;

    public VomsPlugin(Properties properties) throws CertificateException, CRLException, IOException {
        String caDir = properties.getProperty(CADIR);
        String vomsDir = properties.getProperty(VOMSDIR);
        com.google.common.base.Preconditions.checkArgument((caDir != null ? 1 : 0) != 0, (Object)"Undefined property: gplazma.vomsdir.dir");
        com.google.common.base.Preconditions.checkArgument((vomsDir != null ? 1 : 0) != 0, (Object)"Undefined property: gplazma.vomsdir.ca");
        this._pkiVerifier = GSSUtils.getPkiVerifier((String)vomsDir, (String)caDir, (Map)MDC.getCopyOfContextMap());
    }

    public void authenticate(Set<Object> publicCredentials, Set<Object> privateCredentials, Set<Principal> identifiedPrincipals) throws AuthenticationException {
        VOMSValidator validator = new VOMSValidator(null, new ACValidator(this._pkiVerifier));
        boolean primary = true;
        boolean hasX509 = false;
        boolean hasFQANs = false;
        for (Object credential : publicCredentials) {
            if (!(credential instanceof X509Certificate[])) continue;
            hasX509 = true;
            X509Certificate[] chain = (X509Certificate[])credential;
            validator.setClientChain(chain).validate();
            for (String fqan : validator.getAllFullyQualifiedAttributes()) {
                hasFQANs = true;
                identifiedPrincipals.add((Principal)new FQANPrincipal(fqan, primary));
                primary = false;
            }
        }
        Preconditions.checkAuthentication((boolean)hasX509, (String)"no X509 certificate chain");
        Preconditions.checkAuthentication((boolean)hasFQANs, (String)"no FQANs");
    }
}

