/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.missingfiles.plugins;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.security.auth.Subject;
import org.dcache.auth.Subjects;
import org.dcache.missingfiles.plugins.FinalResult;
import org.dcache.missingfiles.plugins.Plugin;
import org.dcache.missingfiles.plugins.Result;
import org.dcache.util.ConfigurationProperties;
import org.dcache.util.FireAndForgetTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SEMsgPlugin
implements Plugin {
    private static final Logger _log = LoggerFactory.getLogger(SEMsgPlugin.class);
    private Executor _executor = Executors.newSingleThreadExecutor();
    private static final String PROPERTY_TOPIC = "missing-files.plugins.semsg.broker.topic";
    private static final String PROPERTY_ENDPOINT = "missing-files.plugins.semsg.broker.endpoint";
    private static final String PROPERTY_COMMAND = "missing-files.plugins.semsg.command";
    private static final String PROPERTY_CERTIFICATE = "missing-files.plugins.semsg.certificate";
    private static final String PROPERTY_PRIVATE_KEY = "missing-files.plugins.semsg.private-key";
    private static final Future<Result> DEFER = new FinalResult(Result.DEFER);
    private String _topic;
    private String _endpoint;
    private String _command;
    private String _certificatePath;
    private String _privateKeyPath;

    public SEMsgPlugin(ConfigurationProperties properties) {
        this._topic = SEMsgPlugin.getRequiredProperty(properties, PROPERTY_TOPIC);
        this._endpoint = SEMsgPlugin.getRequiredProperty(properties, PROPERTY_ENDPOINT);
        this._command = SEMsgPlugin.getRequiredProperty(properties, PROPERTY_COMMAND);
        this._certificatePath = SEMsgPlugin.getRequiredProperty(properties, PROPERTY_CERTIFICATE);
        this._privateKeyPath = SEMsgPlugin.getRequiredProperty(properties, PROPERTY_PRIVATE_KEY);
    }

    private static String getRequiredProperty(ConfigurationProperties properties, String key) {
        String value = properties.getValue(key);
        if (value == null) {
            throw new IllegalArgumentException("missing property: " + key);
        }
        return value;
    }

    public Future<Result> accept(final Subject subject, final String requestPath, String internalPath) {
        this._executor.execute((Runnable)new FireAndForgetTask(new Runnable(){

            @Override
            public void run() {
                SEMsgPlugin.this.sendMessage(subject, requestPath);
            }
        }));
        return DEFER;
    }

    private void sendMessage(Subject subject, String path) {
        String authDn = this.buildAuthDnFor(subject);
        try {
            int rc = this.runCommand(authDn, path);
            if (rc != 0) {
                _log.error("call to command failed: rc={}", (Object)rc);
            }
        }
        catch (InterruptedException e) {
            _log.debug("Interrupted while sending notification");
        }
        catch (IOException e) {
            _log.error("{}", (Object)e.getMessage());
        }
    }

    private String buildAuthDnFor(Subject subject) {
        StringBuilder sb = new StringBuilder();
        String dn = Subjects.getDn((Subject)subject);
        if (dn != null) {
            sb.append(dn);
            for (String fqan : Subjects.getFqans((Subject)subject)) {
                sb.append(',').append(fqan);
            }
        } else {
            sb.append("<UNKNOWN>");
        }
        return sb.toString();
    }

    private int runCommand(String authDn, String path) throws IOException, InterruptedException {
        ArrayList args = Lists.newArrayList((Object[])new String[]{this._command, this._endpoint, authDn, "-t", this._topic, path});
        ProcessBuilder builder = new ProcessBuilder(args);
        _log.debug("Command: {}", builder.command());
        Map<String, String> envar = builder.environment();
        envar.put("X509_USER_CERT", this._certificatePath);
        envar.put("X509_USER_KEY", this._privateKeyPath);
        Process process = builder.start();
        return process.waitFor();
    }
}

