/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth.util;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.X509Name;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.util.Preconditions;
import org.globus.gsi.bc.BouncyCastleUtil;

public class X509Utils {
    public static String getSubjectFromX509Chain(X509Certificate[] chain, boolean omitEmail) throws AuthenticationException {
        try {
            X509Certificate clientcert = BouncyCastleUtil.getIdentityCertificate((X509Certificate[])chain);
            Preconditions.checkAuthentication((clientcert != null ? 1 : 0) != 0, (String)"no client certificate");
            TBSCertificateStructure tbsCert = BouncyCastleUtil.getTBSCertificateStructure((X509Certificate)clientcert);
            return X509Utils.toGlobusString((ASN1Sequence)tbsCert.getSubject().getDERObject(), omitEmail);
        }
        catch (IOException | CertificateException e) {
            throw new AuthenticationException(e.getMessage(), (Throwable)e);
        }
    }

    public static String getSubjectX509Issuer(X509Certificate[] chain, boolean skipImpersonation) throws AuthenticationException {
        if (chain == null || chain.length == 0) {
            return null;
        }
        try {
            X509Certificate clientcert;
            if (skipImpersonation) {
                clientcert = chain[0];
            } else {
                clientcert = BouncyCastleUtil.getIdentityCertificate((X509Certificate[])chain);
                Preconditions.checkAuthentication((clientcert != null ? 1 : 0) != 0, (String)"no client certificate");
            }
            return X509Utils.toGlobusDN(clientcert.getIssuerDN().toString(), skipImpersonation);
        }
        catch (CertificateEncodingException t) {
            throw new AuthenticationException("badly formatted certificate: " + t.getMessage(), (Throwable)t);
        }
        catch (CertificateException t) {
            throw new AuthenticationException("problem with certificate: " + t.getMessage(), (Throwable)t);
        }
    }

    public static String toGlobusDN(String certDN, boolean invert) {
        StringTokenizer tokens = new StringTokenizer(certDN, ",");
        StringBuilder buf = new StringBuilder();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (invert) {
                buf.insert(0, token);
                buf.insert(0, "/");
                continue;
            }
            buf.append("/");
            buf.append(token);
        }
        return buf.toString();
    }

    public static String toGlobusString(ASN1Sequence seq, boolean omitEmail) {
        if (seq == null) {
            return null;
        }
        Enumeration e = seq.getObjects();
        StringBuilder buf = new StringBuilder();
        while (e.hasMoreElements()) {
            ASN1Set set = (ASN1Set)e.nextElement();
            Enumeration ee = set.getObjects();
            boolean didappend = false;
            while (ee.hasMoreElements()) {
                ASN1Sequence s = (ASN1Sequence)ee.nextElement();
                String derString = ((DERString)s.getObjectAt(1)).getString();
                if ("proxy".equalsIgnoreCase(derString.trim())) continue;
                DERObjectIdentifier oid = (DERObjectIdentifier)s.getObjectAt(0);
                String sym = (String)X509Name.DefaultSymbols.get(oid);
                if (oid.equals((Object)X509Name.EmailAddress) && omitEmail) continue;
                if (!didappend) {
                    buf.append('/');
                    didappend = true;
                }
                if (sym == null) {
                    buf.append(oid.getId());
                } else {
                    buf.append(sym);
                }
                buf.append('=');
                buf.append(derString);
                if (!ee.hasMoreElements()) continue;
                buf.append('+');
            }
        }
        return buf.toString();
    }
}

