/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth.util;

import java.io.File;
import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glite.voms.PKIStore;
import org.glite.voms.PKIVerifier;
import org.glite.voms.VOMSAttribute;
import org.glite.voms.VOMSValidator;
import org.glite.voms.ac.ACValidator;
import org.glite.voms.ac.VOMSTrustStore;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.auth.AuthorizationException;
import org.gridforum.jgss.ExtendedGSSContext;
import org.ietf.jgss.GSSException;
import org.slf4j.MDC;

public class GSSUtils {
    static final String SYS_VOMSDIR = "VOMSDIR";
    static final String SYS_CADIR = "CADIR";
    static final String CAPNULL = "/Capability=NULL";
    static final String ROLENULL = "/Role=NULL";
    private static final Map<PKIKey, PKIVerifier> verifiers = new HashMap<PKIKey, PKIVerifier>();

    public static Collection<String> getFQANsFromGSSContext(ExtendedGSSContext gssContext, PKIVerifier pkiVerifier) throws AuthorizationException {
        X509Certificate[] chain;
        try {
            chain = (X509Certificate[])gssContext.inquireByOid(GSSConstants.X509_CERT_CHAIN);
        }
        catch (GSSException gsse) {
            throw new AuthorizationException("Could not extract certificate chain from context " + gsse.getMessage() + "\n" + gsse.getCause());
        }
        try {
            VOMSValidator validator = new VOMSValidator(null, new ACValidator(GSSUtils.getPkiVerifier(null, null, MDC.getCopyOfContextMap())));
            validator.setClientChain(chain).parse();
            List listOfAttributes = validator.getVOMSAttributes();
            return GSSUtils.getFQANSfromVOMSAttributes(listOfAttributes);
        }
        catch (AuthorizationException ae) {
            throw new AuthorizationException(ae.toString());
        }
        catch (Exception e) {
            throw new AuthorizationException("Could not validate role.");
        }
    }

    private static Set<String> getFQANSfromVOMSAttributes(List<VOMSAttribute> listOfAttributes) {
        LinkedHashSet<String> fqans = new LinkedHashSet<String>();
        for (VOMSAttribute vomsAttribute : listOfAttributes) {
            List listOfFqans = vomsAttribute.getFullyQualifiedAttributes();
            for (Object fqan : listOfFqans) {
                String attr = (String)fqan;
                if (attr.endsWith(CAPNULL)) {
                    attr = attr.substring(0, attr.length() - CAPNULL.length());
                }
                if (attr.endsWith(ROLENULL)) {
                    attr = attr.substring(0, attr.length() - ROLENULL.length());
                }
                fqans.add(attr);
            }
        }
        return fqans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized PKIVerifier getPkiVerifier(String vomsDir, String caDir, Map<?, ?> mdcContext) throws IOException, CertificateException, CRLException {
        PKIKey key = new PKIKey(vomsDir, caDir);
        PKIVerifier verifier = verifiers.get(key);
        if (verifier == null) {
            Map map = MDC.getCopyOfContextMap();
            try {
                if (mdcContext != null) {
                    MDC.setContextMap(mdcContext);
                }
                PKIStore vomsStore = null;
                File actualDir = new File(key.vomsDir);
                if (actualDir.exists() && actualDir.isDirectory() && actualDir.list().length > 0) {
                    vomsStore = new PKIStore(key.vomsDir, 1);
                }
                PKIStore caStore = null;
                actualDir = new File(key.caDir);
                if (actualDir.exists() && actualDir.isDirectory() && actualDir.list().length > 0) {
                    caStore = new PKIStore(key.caDir, 2);
                }
                verifier = new PKIVerifier((VOMSTrustStore)vomsStore, caStore);
                verifiers.put(key, verifier);
            }
            finally {
                if (map != null) {
                    MDC.setContextMap((Map)map);
                }
            }
        }
        return verifier;
    }

    private static class PKIKey {
        private String vomsDir;
        private String caDir;

        private PKIKey(String vomsDir, String caDir) {
            this.vomsDir = vomsDir;
            if (this.vomsDir == null) {
                this.vomsDir = System.getProperty(GSSUtils.SYS_VOMSDIR);
            }
            if (this.vomsDir == null) {
                this.vomsDir = PKIStore.DEFAULT_VOMSDIR;
            }
            this.caDir = caDir;
            if (this.caDir == null) {
                this.caDir = System.getProperty(GSSUtils.SYS_CADIR);
            }
            if (this.caDir == null) {
                this.caDir = PKIStore.DEFAULT_CADIR;
            }
        }

        public String toString() {
            return String.valueOf(this.vomsDir) + String.valueOf(this.caDir);
        }

        public boolean equals(Object object) {
            if (!(object instanceof PKIKey)) {
                return false;
            }
            return this.toString().equals(object.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

