/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.movers;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.ChecksumFactory;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.CellEndpoint;
import dmg.util.Args;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SocketChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.dcache.net.ChallengeReader;
import org.dcache.net.ProtocolConnectionPoolFactory;
import org.dcache.pool.movers.ChecksumMover;
import org.dcache.pool.movers.DCapChallengeReader;
import org.dcache.pool.movers.DCapOutputByteBuffer;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.MoverIoBuffer;
import org.dcache.pool.movers.MoverProtocol;
import org.dcache.pool.repository.Allocator;
import org.dcache.pool.repository.RepositoryChannel;
import org.dcache.util.Checksum;
import org.dcache.util.ChecksumType;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCapProtocol_3_nio
implements MoverProtocol,
ChecksumMover {
    private static Logger _log = LoggerFactory.getLogger(DCapProtocol_3_nio.class);
    private static Logger _logSocketIO = LoggerFactory.getLogger((String)"logger.dev.org.dcache.io.socket");
    private static final Logger _logSpaceAllocation = LoggerFactory.getLogger((String)("logger.dev.org.dcache.poolspacemonitor." + DCapProtocol_3_nio.class.getName()));
    private static final int INC_SPACE = 0x3200000;
    private final Args _args;
    private final Map<String, Object> _context;
    private final CellEndpoint _cell;
    private long _bytesTransferred = -1L;
    private long _transferStarted;
    private long _transferTime = -1L;
    private long _lastTransferred = System.currentTimeMillis();
    private ByteBuffer _bigBuffer;
    private String _status = "None";
    private boolean _io_ok = true;
    private long _ioError = -1L;
    private PnfsId _pnfsId;
    private int _sessionId = -1;
    private boolean _wasChanged;
    private Checksum _clientChecksum;
    private ChecksumFactory _checksumFactory;
    private MessageDigest _digest;
    private final MoverIoBuffer _defaultBufferSize = new MoverIoBuffer(262144, 262144, 262144);
    private final MoverIoBuffer _maxBufferSize = new MoverIoBuffer(0x100000, 0x100000, 0x100000);
    private SpaceMonitorHandler _spaceMonitorHandler;
    private static ProtocolConnectionPoolFactory protocolConnectionPoolFactory;

    private void initialiseBuffer(MoverIoBuffer bufferSize) {
        try {
            this._bigBuffer = this._bigBuffer == null ? ByteBuffer.allocate(bufferSize.getIoBufferSize()) : this._bigBuffer;
        }
        catch (OutOfMemoryError om) {
            this._bigBuffer = ByteBuffer.allocate(32768);
        }
    }

    private MoverIoBuffer prepareBufferSize(StorageInfo storage) {
        String tmp;
        MoverIoBuffer bufferSize = new MoverIoBuffer(this._defaultBufferSize);
        try {
            tmp = storage.getKey("send");
            if (tmp != null) {
                bufferSize.setSendBufferSize(Math.min(Integer.parseInt(tmp), this._maxBufferSize.getSendBufferSize()));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            tmp = storage.getKey("receive");
            if (tmp != null) {
                bufferSize.setRecvBufferSize(Math.min(Integer.parseInt(tmp), this._maxBufferSize.getRecvBufferSize()));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            tmp = storage.getKey("bsize");
            if (tmp != null) {
                bufferSize.setIoBufferSize(Math.min(Integer.parseInt(tmp), this._maxBufferSize.getIoBufferSize()));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return bufferSize;
    }

    public DCapProtocol_3_nio(CellEndpoint cell) {
        this._cell = cell;
        this._args = this._cell.getArgs();
        this._context = this._cell.getDomainContext();
        _log.info("DCapProtocol_3 (nio) created $Id: DCapProtocol_3_nio.java,v 1.17 2007-10-02 13:35:52 tigran Exp $");
        this._defaultBufferSize.setBufferSize(this.getParameterInt("defaultSendBufferSize", this._defaultBufferSize.getSendBufferSize()), this.getParameterInt("defaultRecvBufferSize", this._defaultBufferSize.getRecvBufferSize()), this.getParameterInt("defaultIoBufferSize", this._defaultBufferSize.getIoBufferSize()));
        this._maxBufferSize.setBufferSize(this.getParameterInt("maxSendBufferSize", this._maxBufferSize.getSendBufferSize()), this.getParameterInt("maxRecvBufferSize", this._maxBufferSize.getRecvBufferSize()), this.getParameterInt("maxIoBufferSize", this._maxBufferSize.getIoBufferSize()));
        _log.info("Setup : Defaults Buffer Sizes  : {}", (Object)this._defaultBufferSize);
        _log.info("Setup : Max Buffer Sizes       : {}", (Object)this._maxBufferSize);
    }

    private synchronized int getParameterInt(String name, int defaultValue) {
        String stringValue = (String)this._context.get("dCap3-" + name);
        stringValue = stringValue == null ? this._args.getOpt(name) : stringValue;
        try {
            return stringValue == null ? defaultValue : Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public String toString() {
        return "SM=" + this._spaceMonitorHandler + ";S=" + this._status;
    }

    protected String getCellName() {
        return this._cell.getCellInfo().getCellName();
    }

    protected String getCellDomainName() {
        return this._cell.getCellInfo().getDomainName();
    }

    /*
     * Exception decompiling
     */
    public void runIO(FileAttributes fileAttributes, RepositoryChannel fileChannel, ProtocolInfo protocol, Allocator allocator, IoMode access) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doTheReadv(RepositoryChannel fileChannel, DCapOutputByteBuffer cntOut, SocketChannel socketChannel, RequestBlock requestBLock) throws Exception {
        cntOut.writeDATA_HEADER();
        socketChannel.write(cntOut.buffer());
        int blocks = requestBLock.nextInt();
        _log.debug("READV: {} to read", (Object)blocks);
        int maxBuffer = this._bigBuffer.capacity() - 4;
        block3: for (int i = 0; i < blocks; ++i) {
            int count;
            long offset = requestBLock.nextLong();
            int len = count = requestBLock.nextInt();
            _log.debug("READV: offset/len: {}/{}", (Object)offset, (Object)count);
            while (count > 0) {
                int rc;
                int bytesToRead = maxBuffer > count ? count : maxBuffer;
                try {
                    this._bigBuffer.clear().limit(bytesToRead + 4);
                    this._bigBuffer.position(4);
                    rc = fileChannel.read(this._bigBuffer, offset + (long)(len - count));
                    if (rc <= 0) {
                        continue block3;
                    }
                }
                catch (ClosedByInterruptException ee) {
                    Thread.interrupted();
                    throw new InterruptedException(ee.getMessage());
                }
                catch (IOException ee) {
                    this._io_ok = false;
                    continue block3;
                }
                this._bigBuffer.flip();
                this._bigBuffer.putInt(rc).rewind();
                _log.debug("READV: sending: {} bytes", (Object)this._bigBuffer.limit());
                socketChannel.write(this._bigBuffer);
                count -= rc;
                this._bytesTransferred += (long)rc;
            }
        }
    }

    private void scanCloseBlock(RequestBlock requestBlock, StorageInfo storage) {
        int blockSize = requestBlock.nextInt();
        if (blockSize < 4) {
            _log.error("Not a valid block size in close");
            throw new IllegalArgumentException("Not a valid block size in close");
        }
        int blockMode = requestBlock.nextInt();
        if (blockMode != 1) {
            _log.error("Unknown block mode ({}) in close", (Object)blockMode);
            requestBlock.skip(blockSize - 4);
            return;
        }
        int crcType = requestBlock.nextInt();
        byte[] array = new byte[blockSize - 8];
        requestBlock.get(array);
        this._clientChecksum = new Checksum(ChecksumType.getChecksumType((int)crcType), array);
        storage.setKey("flag-c", this._clientChecksum.toString());
    }

    private void doTheSeek(RepositoryChannel fileChannel, int whence, long offset, boolean writeAllowed) {
        try {
            long newOffset;
            long eofSize = fileChannel.size();
            long position = fileChannel.position();
            switch (whence) {
                case 0: {
                    _log.debug("SEEK {} SEEK_SET", (Object)offset);
                    if (offset == 0L) {
                        this._io_ok = true;
                    }
                    newOffset = offset;
                    break;
                }
                case 1: {
                    _log.debug("SEEK {} SEEK_CURRENT", (Object)offset);
                    newOffset = position + offset;
                    break;
                }
                case 2: {
                    _log.debug("SEEK {} SEEK_END", (Object)offset);
                    newOffset = eofSize + offset;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid seek mode : " + whence);
                }
            }
            if (newOffset > eofSize && !writeAllowed) {
                throw new IOException("Seek beyond EOF not allowed (write not allowed)");
            }
            this._spaceMonitorHandler.getSpace(newOffset);
            fileChannel.position(newOffset);
        }
        catch (Exception ee) {
            _log.error("Problem in seek : {}", (Object)ee.toString());
        }
    }

    private void doTheWrite(RepositoryChannel fileChannel, DCapOutputByteBuffer cntOut, SocketChannel socketChannel) throws Exception {
        RequestBlock requestBlock = new RequestBlock();
        requestBlock.read(socketChannel);
        if (requestBlock.getCommandCode() != 8) {
            throw new IOException("Expecting : 8; got : " + requestBlock.getCommandCode());
        }
        while (!Thread.currentThread().isInterrupted()) {
            this._status = "WaitingForSize";
            this._bigBuffer.clear().limit(4);
            while (this._bigBuffer.hasRemaining()) {
                if (socketChannel.read(this._bigBuffer) >= 0) continue;
                throw new EOFException("EOF on input socket");
            }
            this._bigBuffer.rewind();
            int rest = this._bigBuffer.getInt();
            _log.debug("Next data block : {} bytes", (Object)rest);
            long position = fileChannel.position();
            this._spaceMonitorHandler.getSpace(position + (long)rest);
            long bytesAdded = 0L;
            if (rest == 0) continue;
            if (rest < 0) break;
            this._wasChanged = true;
            while (rest > 0) {
                int size = this._bigBuffer.capacity() > rest ? rest : this._bigBuffer.capacity();
                this._status = "WaitingForInput";
                this._bigBuffer.clear().limit(size);
                int rc = socketChannel.read(this._bigBuffer);
                if (rc <= 0) break;
                if (this._io_ok) {
                    this._status = "WaitingForWrite";
                    try {
                        this._bigBuffer.flip();
                        bytesAdded += (long)fileChannel.write(this._bigBuffer);
                        this.updateChecksum(this._bigBuffer);
                    }
                    catch (ClosedByInterruptException ee) {
                        Thread.interrupted();
                        throw new InterruptedException(ee.getMessage());
                    }
                    catch (IOException ioe) {
                        _log.error("IOException in writing data to disk : {}", (Object)ioe.toString());
                        this._io_ok = false;
                    }
                }
                rest -= rc;
                this._bytesTransferred += (long)rc;
                if (this._ioError <= 0L || this._bytesTransferred <= this._ioError) continue;
                this._io_ok = false;
            }
            this._spaceMonitorHandler.newFilePosition(position + bytesAdded);
            _log.debug("Block Done");
        }
        this._status = "Done";
    }

    private void updateChecksum(ByteBuffer buffer) {
        if (this._digest != null) {
            buffer.rewind();
            this._digest.update(buffer);
        }
    }

    private void doTheRead(RepositoryChannel fileChannel, DCapOutputByteBuffer cntOut, SocketChannel socketChannel, long blockSize) throws Exception {
        cntOut.writeDATA_HEADER();
        socketChannel.write(cntOut.buffer());
        if (blockSize == 0L) {
            cntOut.writeEND_OF_BLOCK();
            socketChannel.write(cntOut.buffer());
            return;
        }
        long rest = blockSize;
        int maxBuffer = this._bigBuffer.capacity() - 4;
        while (!Thread.currentThread().isInterrupted()) {
            int rc;
            int size = (long)maxBuffer > rest ? (int)rest : maxBuffer;
            try {
                this._bigBuffer.clear().limit(size + 4);
                this._bigBuffer.position(4);
                rc = fileChannel.read(this._bigBuffer);
                if (rc <= 0) {
                    break;
                }
            }
            catch (ClosedByInterruptException ee) {
                Thread.interrupted();
                throw new InterruptedException(ee.getMessage());
            }
            catch (IOException ee) {
                this._io_ok = false;
                break;
            }
            this._bigBuffer.flip();
            this._bigBuffer.putInt(rc).rewind();
            socketChannel.write(this._bigBuffer);
            rest -= (long)rc;
            this._bytesTransferred += (long)rc;
            if (this._ioError > 0L && this._bytesTransferred > this._ioError) {
                this._io_ok = false;
                break;
            }
            if (rest > 0L) continue;
        }
        cntOut.writeDATA_TRAILER();
        socketChannel.write(cntOut.buffer());
    }

    public long getLastTransferred() {
        return this._lastTransferred;
    }

    public long getBytesTransferred() {
        return this._bytesTransferred;
    }

    public long getTransferTime() {
        return this._transferTime < 0L ? System.currentTimeMillis() - this._transferStarted : this._transferTime;
    }

    public void enableTransferChecksum(ChecksumType suggestedAlgorithm) throws NoSuchAlgorithmException {
        this._checksumFactory = ChecksumFactory.getFactory((ChecksumType)suggestedAlgorithm);
        this._digest = this._checksumFactory.create();
    }

    public Checksum getExpectedChecksum() {
        return this._clientChecksum;
    }

    public Checksum getActualChecksum() {
        return this._digest == null ? null : this._checksumFactory.create(this._digest.digest());
    }

    static {
        int port = 0;
        try {
            port = Integer.parseInt(System.getProperty("org.dcache.dcap.port"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        protocolConnectionPoolFactory = new ProtocolConnectionPoolFactory(port, (ChallengeReader)new DCapChallengeReader());
    }

    private class RequestBlock {
        private ByteBuffer _buffer = ByteBuffer.allocate(16384);
        private int _commandSize;
        private int _commandCode;

        private RequestBlock() {
        }

        private void read(SocketChannel channel) throws Exception {
            this._commandCode = 0;
            this._commandSize = 0;
            this._buffer.clear().limit(4);
            this.fillBuffer(channel);
            this._buffer.rewind();
            this._commandSize = this._buffer.getInt();
            if (this._commandSize < 4) {
                throw new CacheException(44, "Protocol Violation (cl<4)");
            }
            try {
                this._buffer.clear().limit(this._commandSize);
            }
            catch (IllegalArgumentException iae) {
                _log.error("Command size excided command block size : " + this._commandSize + "/" + this._buffer.capacity());
                throw iae;
            }
            this.fillBuffer(channel);
            this._buffer.rewind();
            this._commandCode = this._buffer.getInt();
        }

        private int remaining() {
            return this._buffer.remaining();
        }

        private int getCommandCode() {
            return this._commandCode;
        }

        private int nextInt() {
            return this._buffer.getInt();
        }

        private long nextLong() {
            return this._buffer.getLong();
        }

        private void fillBuffer(SocketChannel channel) throws Exception {
            while (this._buffer.hasRemaining()) {
                if (channel.read(this._buffer) >= 0) continue;
                throw new EOFException("EOF on input socket (fillBuffer)");
            }
        }

        private void skip(int skip) {
            this._buffer.position(this._buffer.position() + skip);
        }

        private void get(byte[] array) {
            this._buffer.get(array);
        }

        public String toString() {
            return "RequestBlock [Size=" + this._commandSize + " Code=" + this._commandCode + " Buffer=" + this._buffer;
        }

        static /* synthetic */ int access$1200(RequestBlock x0) {
            return x0.remaining();
        }
    }

    private class SpaceMonitorHandler {
        private final Allocator _allocator;
        private long _spaceAllocated;
        private long _allocationSpace = 0x3200000L;
        private long _spaceUsed;

        private SpaceMonitorHandler(Allocator allocator) {
            this._allocator = allocator;
        }

        private void setAllocationSpace(long allocSpace) {
            this._allocationSpace = allocSpace;
        }

        private void setInitialSpace(long space) {
            this._spaceAllocated = space;
            this._spaceUsed = space;
        }

        public String toString() {
            return "{a=" + this._spaceAllocated + ";u=" + this._spaceUsed + "}";
        }

        private void getSpace(long newEof) throws InterruptedException {
            if (this._allocator == null) {
                return;
            }
            while (newEof > this._spaceAllocated) {
                DCapProtocol_3_nio.this._status = "WaitingForSpace(" + this._allocationSpace + ")";
                _log.debug("Allocating new space : {}", (Object)this._allocationSpace);
                _logSpaceAllocation.debug("ALLOC: {} : {}", (Object)DCapProtocol_3_nio.this._pnfsId, (Object)this._allocationSpace);
                this._allocator.allocate(this._allocationSpace);
                this._spaceAllocated += this._allocationSpace;
                _log.debug("Allocated new space : {}", (Object)this._allocationSpace);
                DCapProtocol_3_nio.this._status = "";
            }
        }

        private void newFilePosition(long newPosition) {
            this._spaceUsed = Math.max(newPosition, this._spaceUsed);
        }

        static /* synthetic */ void access$500(SpaceMonitorHandler x0, long x1) {
            x0.setAllocationSpace(x1);
        }

        static /* synthetic */ void access$600(SpaceMonitorHandler x0, long x1) {
            x0.setInitialSpace(x1);
        }
    }
}

