/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.pools;

import com.google.common.collect.Ranges;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.NotDirCacheException;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.DCapProtocolInfo;
import diskCacheV111.vehicles.PoolIoFileMessage;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.DelayedReply;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.util.Args;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Socket;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.dcache.cells.AbstractCell;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.FileType;
import org.dcache.pool.movers.DCapDataOutputStream;
import org.dcache.util.list.DirectoryEntry;
import org.dcache.util.list.DirectoryListPrinter;
import org.dcache.util.list.DirectoryListSource;
import org.dcache.util.list.ListDirectoryHandler;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryLookUpPool
extends AbstractCell {
    private static final Logger _log = LoggerFactory.getLogger(DirectoryLookUpPool.class);
    private static final CellPath PNFS_MANAGER = new CellPath("PnfsManager");
    private final String _poolName;
    private final Args _args;
    private PnfsHandler _pnfs;
    private DirectoryListSource _list;
    public static final String hh_ls_$_1 = "ls <path>";

    public DirectoryLookUpPool(String poolName, String args) throws InterruptedException, ExecutionException {
        super(poolName, args);
        this._poolName = poolName;
        this._args = this.getArgs();
        this.doInit();
    }

    protected void init() throws IllegalArgumentException {
        _log.info("Lookup Pool " + this._poolName + " starting");
        this._pnfs = new PnfsHandler((CellEndpoint)this, PNFS_MANAGER);
        ListDirectoryHandler listHandler = new ListDirectoryHandler(this._pnfs);
        this.addMessageListener((CellMessageReceiver)listHandler);
        this._list = listHandler;
        this.useInterpreter(true);
    }

    public void getInfo(PrintWriter pw) {
        pw.println("Revision          : [$Id: DirectoryLookUpPool.java,v 1.7 2007-07-26 14:34:12 tigran Exp $]");
    }

    public void messageToForward(CellMessage cellMessage) {
        this.messageArrived(cellMessage);
    }

    private String list(FsPath path) throws InterruptedException, CacheException {
        StringBuilder sb = new StringBuilder();
        try {
            this._list.printDirectory(null, (DirectoryListPrinter)new DirectoryPrinter(sb), path, null, Ranges.all());
        }
        catch (FileNotFoundCacheException e) {
            sb.append("Path ").append(path).append(" does not exist.");
        }
        catch (NotDirCacheException e) {
            this._list.printFile(null, (DirectoryListPrinter)new FilePrinter(sb), path);
        }
        return sb.toString();
    }

    public DelayedReply ac_ls_$_1(Args args) {
        FsPath path = new FsPath(args.argv(0));
        ListThread thread = new ListThread(path);
        new Thread((Runnable)thread, "list[" + path + "]").start();
        return thread;
    }

    public PoolIoFileMessage messageArrived(PoolIoFileMessage message) {
        DCapProtocolInfo dcap = (DCapProtocolInfo)message.getProtocolInfo();
        PnfsId pnfsId = message.getPnfsId();
        DirectoryService service = new DirectoryService(dcap, pnfsId);
        new Thread((Runnable)service, "list[" + pnfsId + "]").start();
        message.setSucceeded();
        return message;
    }

    private class DirectoryService
    implements Runnable {
        private DCapProtocolInfo dcap;
        private int sessionId;
        private DCapDataOutputStream ostream;
        private DataInputStream istream;
        private Socket dataSocket;
        private DCapDataOutputStream cntOut;
        private DataInputStream cntIn;
        private PnfsId pnfsId;

        DirectoryService(DCapProtocolInfo dcap, PnfsId pnfsId) {
            this.dcap = dcap;
            this.pnfsId = pnfsId;
            this.sessionId = dcap.getSessionId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean done = false;
            int index = 0;
            try {
                String path = DirectoryLookUpPool.this._pnfs.getPathByPnfsId(this.pnfsId);
                String dirList = DirectoryLookUpPool.this.list(new FsPath(path));
                this.connectToClinet();
                block43: while (!done && !Thread.currentThread().isInterrupted()) {
                    int commandSize = this.cntIn.readInt();
                    if (commandSize < 4) {
                        throw new CacheException(44, "Protocol Violation (cl<4)");
                    }
                    int commandCode = this.cntIn.readInt();
                    switch (commandCode) {
                        case 4: {
                            this.cntOut.writeACK(4);
                            done = true;
                            continue block43;
                        }
                        case 2: {
                            int minSize = 12;
                            if (commandSize < minSize) {
                                throw new CacheException(45, "Protocol Violation (clREAD<8)");
                            }
                            long numberOfEntries = this.cntIn.readLong();
                            _log.debug("requested " + numberOfEntries + " bytes");
                            this.cntOut.writeACK(2);
                            index += this.doReadDir(this.cntOut, this.ostream, dirList, index, numberOfEntries);
                            this.cntOut.writeFIN(2);
                            continue block43;
                        }
                    }
                    this.cntOut.writeACK(1717, 9, "Invalid mover command : " + commandCode);
                }
            }
            catch (CacheException e) {
                _log.error(e.toString());
            }
            catch (IOException e) {
                _log.warn(e.toString());
            }
            catch (InterruptedException e) {
            }
            finally {
                if (this.ostream != null) {
                    try {
                        this.ostream.close();
                    }
                    catch (IOException e) {
                        _log.warn(e.toString());
                    }
                }
                if (this.istream != null) {
                    try {
                        this.istream.close();
                    }
                    catch (IOException e) {
                        _log.warn(e.toString());
                    }
                }
                if (this.dataSocket != null) {
                    try {
                        this.dataSocket.close();
                    }
                    catch (IOException e) {
                        _log.warn(e.toString());
                    }
                }
            }
        }

        void connectToClinet() throws IOException {
            this.dataSocket = new Socket(this.dcap.getSocketAddress().getAddress(), this.dcap.getSocketAddress().getPort());
            this.ostream = new DCapDataOutputStream(this.dataSocket.getOutputStream());
            this.istream = new DataInputStream(this.dataSocket.getInputStream());
            _log.info("Connected to {}", (Object)this.dcap.getSocketAddress());
            this.cntOut = this.ostream;
            this.cntIn = this.istream;
            this.cntOut.writeInt(this.sessionId);
            this.cntOut.writeInt(0);
            this.cntOut.flush();
        }

        private int doReadDir(DCapDataOutputStream cntOut, DCapDataOutputStream ostream, String dirList, int index, long len) throws IOException {
            if (index > dirList.length()) {
                throw new ArrayIndexOutOfBoundsException("requested index greater then directory size");
            }
            byte[] data = dirList.getBytes();
            long rc = len > (long)(dirList.length() - index) ? (long)(dirList.length() - index) : len;
            cntOut.writeDATA_HEADER();
            ostream.writeDATA_BLOCK(data, index, (int)rc);
            ostream.writeDATA_TRAILER();
            return (int)rc;
        }
    }

    class ListThread
    extends DelayedReply
    implements Runnable {
        private final FsPath _path;

        public ListThread(FsPath path) {
            this._path = path;
        }

        @Override
        public void run() {
            try {
                try {
                    this.send((Serializable)((Object)DirectoryLookUpPool.this.list(this._path)));
                }
                catch (CacheException e) {
                    this.send((Serializable)((Object)e));
                }
            }
            catch (InterruptedException e) {
            }
            catch (NoRouteToCellException e) {
                _log.warn("Failed to send list reply: " + e.getMessage());
            }
        }
    }

    class FilePrinter
    implements DirectoryListPrinter {
        private final StringBuilder _out;

        public FilePrinter(StringBuilder out) {
            this._out = out;
        }

        public Set<FileAttribute> getRequiredAttributes() {
            return EnumSet.of(FileAttribute.TYPE, FileAttribute.SIZE);
        }

        public void print(FsPath dir, FileAttributes dirAttr, DirectoryEntry entry) {
            FileAttributes attr = entry.getFileAttributes();
            if (attr.getFileType() == FileType.REGULAR) {
                this._out.append(new FsPath(dir, entry.getName()));
                this._out.append(" : ").append(attr.getSize());
            }
        }
    }

    class DirectoryPrinter
    implements DirectoryListPrinter {
        private final StringBuilder _out;

        public DirectoryPrinter(StringBuilder out) {
            this._out = out;
        }

        public Set<FileAttribute> getRequiredAttributes() {
            return EnumSet.of(FileAttribute.PNFSID, FileAttribute.TYPE, FileAttribute.SIZE);
        }

        public void print(FsPath dir, FileAttributes dirAttr, DirectoryEntry entry) {
            FileAttributes attr = entry.getFileAttributes();
            this._out.append(attr.getPnfsId());
            switch (attr.getFileType()) {
                case DIR: {
                    this._out.append(":d:");
                    break;
                }
                case REGULAR: 
                case LINK: 
                case SPECIAL: {
                    this._out.append(":f:");
                }
            }
            this._out.append(attr.getSize()).append(':').append(entry.getName());
            this._out.append('\n');
        }
    }
}

