/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.util.net;

import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Inet6AddressMatcher {
    private byte[] _netmask;
    private byte[] _address;

    public Inet6AddressMatcher(String netmask, InetAddress address) {
        this._netmask = this.mask2array(netmask);
        this._address = address.getAddress();
    }

    private byte[] mask2array(String mask) {
        byte[] bi_bytes = new BigInteger(mask, 16).toByteArray();
        byte[] bytes = new byte[16];
        int i = bytes.length - 1;
        for (int j = bi_bytes.length - 1; i >= 0 && j >= 0; --i, --j) {
            bytes[i] = bi_bytes[j];
        }
        return bytes;
    }

    public boolean matches(InetAddress address) {
        byte[] addressBytes = address.getAddress();
        for (int index = 0; index < 16; ++index) {
            if (addressBytes[index] == (this._address[index] & this._netmask[index])) continue;
            return false;
        }
        return true;
    }

    public static boolean matches(String netmask, InetAddress inetAddress) {
        Inet6AddressMatcher addressMatcher = new Inet6AddressMatcher(netmask, inetAddress);
        return addressMatcher.matches(inetAddress);
    }

    public static boolean matches(String netmask, String address) throws UnknownHostException {
        return Inet6AddressMatcher.matches(netmask, Inet6Address.getByName(address));
    }
}

