/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.parser;

import java.util.ArrayList;
import org.dcache.acl.ACE;
import org.dcache.acl.ACL;
import org.dcache.acl.enums.RsType;
import org.dcache.acl.parser.ACEParser;

public class ACLParser {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final String SEPARATOR = ":";
    private static ACLParser _SINGLETON = new ACLParser();

    private ACLParser() {
    }

    public static ACLParser instance() {
        return _SINGLETON;
    }

    public static ACL parse(String acl_spec) throws IllegalArgumentException {
        if (acl_spec == null || acl_spec.length() == 0) {
            throw new IllegalArgumentException("Invalid acl_spec.");
        }
        String[] split = acl_spec.split(LINE_SEPARATOR);
        if (split == null) {
            throw new IllegalArgumentException("acl_spec can't be splitted: " + acl_spec);
        }
        int len = split.length;
        if (len < 2) {
            throw new IllegalArgumentException("Count tags invalid in acl_spec: " + acl_spec);
        }
        String rsInfo = split[0];
        if (rsInfo.length() == 0) {
            throw new IllegalArgumentException("Invalid acl_spec: " + acl_spec);
        }
        String[] splitRsInfo = rsInfo.split(SEPARATOR);
        if (splitRsInfo.length != 2) {
            throw new IllegalArgumentException("Invalid acl_spec: " + acl_spec);
        }
        String rsID = splitRsInfo[0];
        if (rsID.length() == 0) {
            throw new IllegalArgumentException("Invalid acl_spec: " + acl_spec);
        }
        RsType rsType = RsType.valueOf(splitRsInfo[1]);
        ArrayList<ACE> aces = new ArrayList<ACE>();
        for (int index = 1; index < len; ++index) {
            aces.add(ACEParser.parse(split[index]));
        }
        return new ACL(rsType, aces);
    }

    public static ACL parseAdm(RsType rsType, String aces_spec) throws IllegalArgumentException {
        return new ACL(rsType, ACEParser.parseAdm(aces_spec));
    }
}

