/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl.enums;

import org.dcache.acl.enums.RsType;

public enum AccessMask {
    READ_DATA(1, 'r', RsType.FILE),
    LIST_DIRECTORY(1, 'l', RsType.DIR),
    WRITE_DATA(2, 'w', RsType.FILE),
    ADD_FILE(2, 'f', RsType.DIR),
    APPEND_DATA(4, 'a', RsType.FILE),
    ADD_SUBDIRECTORY(4, 's', RsType.DIR),
    READ_NAMED_ATTRS(8, 'n'),
    WRITE_NAMED_ATTRS(16, 'N'),
    EXECUTE(32, 'x'),
    DELETE_CHILD(64, 'D'),
    READ_ATTRIBUTES(128, 't'),
    WRITE_ATTRIBUTES(256, 'T'),
    DELETE(65536, 'd'),
    READ_ACL(131072, 'c'),
    WRITE_ACL(262144, 'C'),
    WRITE_OWNER(524288, 'o'),
    SYNCHRONIZE(0x100000, 'y');

    private final int _value;
    private final char _abbreviation;
    private final RsType _type;

    private AccessMask(int value, char abbreviation) {
        this._value = value;
        this._abbreviation = abbreviation;
        this._type = null;
    }

    private AccessMask(int value, char abbreviation, RsType type) {
        this._value = value;
        this._abbreviation = abbreviation;
        this._type = type;
    }

    public int getValue() {
        return this._value;
    }

    public char getAbbreviation() {
        return this._abbreviation;
    }

    public RsType getType() {
        return this._type;
    }

    public boolean matches(int accessMask) {
        return (this._value & accessMask) == this._value;
    }

    public static String asString(int accessMask) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder();
        for (AccessMask accessMsk : AccessMask.values()) {
            if (!accessMsk.matches(accessMask)) continue;
            sb.append(accessMsk.getAbbreviation());
        }
        return sb.toString();
    }

    public static String asString(int accessMask, RsType type) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder();
        for (AccessMask accessMsk : AccessMask.values()) {
            if (accessMsk._type != null && type != null && accessMsk._type != type || !accessMsk.matches(accessMask)) continue;
            sb.append(accessMsk.getAbbreviation());
        }
        return sb.toString();
    }

    public static int parseInt(String strAccessMask) throws IllegalArgumentException {
        char[] chars;
        if (strAccessMask == null || strAccessMask.length() == 0) {
            throw new IllegalArgumentException("accessMask is " + (strAccessMask == null ? "NULL" : "Empty"));
        }
        int mask = 0;
        for (char ch : chars = strAccessMask.toCharArray()) {
            mask |= AccessMask.fromAbbreviation((char)ch)._value;
        }
        return mask;
    }

    public static AccessMask fromAbbreviation(char abbreviation) throws IllegalArgumentException {
        switch (abbreviation) {
            case 'r': {
                return READ_DATA;
            }
            case 'l': {
                return LIST_DIRECTORY;
            }
            case 'w': {
                return WRITE_DATA;
            }
            case 'f': {
                return ADD_FILE;
            }
            case 'a': {
                return APPEND_DATA;
            }
            case 's': {
                return ADD_SUBDIRECTORY;
            }
            case 'n': {
                return READ_NAMED_ATTRS;
            }
            case 'N': {
                return WRITE_NAMED_ATTRS;
            }
            case 'x': {
                return EXECUTE;
            }
            case 'D': {
                return DELETE_CHILD;
            }
            case 't': {
                return READ_ATTRIBUTES;
            }
            case 'T': {
                return WRITE_ATTRIBUTES;
            }
            case 'd': {
                return DELETE;
            }
            case 'c': {
                return READ_ACL;
            }
            case 'C': {
                return WRITE_ACL;
            }
            case 'o': {
                return WRITE_OWNER;
            }
            case 'y': {
                return SYNCHRONIZE;
            }
        }
        throw new IllegalArgumentException("Invalid access mask abbreviation: " + abbreviation);
    }
}

