/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import org.dcache.acl.ACE;
import org.dcache.acl.ACLException;
import org.dcache.acl.enums.RsType;

public class ACL
implements Serializable {
    private static final long serialVersionUID = -1883807712749350105L;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final String SPACE_SEPARATOR = " ";
    private static final String SEPARATOR = ":";
    private final RsType _rsType;
    private final List<ACE> _list;

    public ACL(RsType rsType, List<ACE> list) {
        this._rsType = rsType;
        this._list = ImmutableList.copyOf(list);
    }

    public List<ACE> getList() {
        return this._list;
    }

    public RsType getRsType() {
        return this._rsType;
    }

    public boolean isEmpty() {
        return this._list.isEmpty();
    }

    public String toNFSv4String() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this._rsType).append(SPACE_SEPARATOR);
        for (int index = 0; index < this._list.size(); ++index) {
            if (index > 0) {
                sb.append(SPACE_SEPARATOR);
            }
            sb.append(this._list.get(index).toNFSv4String(this._rsType));
        }
        return sb.toString();
    }

    public String toOrgString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._rsType.getValue()).append(LINE_SEPARATOR);
        for (ACE ace : this._list) {
            sb.append(ace.toOrgString()).append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    public String toExtraFormat() throws ACLException {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this._rsType);
        for (ACE ace : this._list) {
            sb.append(LINE_SEPARATOR).append(ace.toExtraFormat(this._rsType));
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ACL: ");
        sb.append("rsType = ").append((Object)this._rsType);
        for (ACE ace : this._list) {
            sb.append(LINE_SEPARATOR).append(ace.toString(this._rsType));
        }
        return sb.toString();
    }
}

