/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.acl;

import java.io.Serializable;
import org.dcache.acl.ACLException;
import org.dcache.acl.enums.AccessMask;
import org.dcache.acl.enums.AceFlags;
import org.dcache.acl.enums.AceType;
import org.dcache.acl.enums.RsType;
import org.dcache.acl.enums.Who;

public class ACE
implements Serializable {
    private static final long serialVersionUID = -7088617639500399472L;
    public static final String DEFAULT_ADDRESS_MSK = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
    private static final String SPACE_SEPARATOR = " ";
    private static final String SEPARATOR = ":";
    private final AceType _type;
    private final int _flags;
    private final int _accessMsk;
    private final Who _who;
    private final int _whoID;
    private final String _addressMsk;

    public ACE(AceType type, int flags, int accessMsk, Who who, int whoID, String addressMsk) {
        this._type = type;
        this._flags = flags;
        this._accessMsk = accessMsk;
        this._who = who;
        this._whoID = whoID;
        this._addressMsk = addressMsk;
    }

    public int getAccessMsk() {
        return this._accessMsk;
    }

    public String getAddressMsk() {
        return this._addressMsk;
    }

    public boolean isDefaultAddressMsk(String addressMsk) {
        return DEFAULT_ADDRESS_MSK.equalsIgnoreCase(addressMsk);
    }

    public boolean isDefaultAddressMsk() {
        return this.isDefaultAddressMsk(this._addressMsk);
    }

    public int getFlags() {
        return this._flags;
    }

    public AceType getType() {
        return this._type;
    }

    public Who getWho() {
        return this._who;
    }

    public int getWhoID() {
        return this._whoID;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ACE other = (ACE)obj;
        if (this._type != other._type) {
            return false;
        }
        if (this._flags != other._flags) {
            return false;
        }
        if (this._accessMsk != other._accessMsk) {
            return false;
        }
        if (this._who != other._who) {
            return false;
        }
        if (this._whoID != other._whoID) {
            return false;
        }
        return this._addressMsk.equals(other._addressMsk);
    }

    public int hashCode() {
        return this._type.hashCode() ^ this._flags ^ this._accessMsk ^ this._who.hashCode() ^ this._whoID ^ this._addressMsk.hashCode();
    }

    public String toNFSv4String(RsType rsType) {
        StringBuilder sb = new StringBuilder();
        sb.append(this._who.getAbbreviation());
        if (this._who == Who.USER || this._who == Who.GROUP) {
            sb.append(SEPARATOR).append(this._whoID);
        }
        sb.append(SEPARATOR).append(AccessMask.asString(this._accessMsk, rsType));
        if (this._flags != 0) {
            sb.append(SEPARATOR).append(AceFlags.asString(this._flags));
        }
        sb.append(SEPARATOR).append(this._type.getAbbreviation());
        if (!this.isDefaultAddressMsk()) {
            sb.append(SEPARATOR).append(this._addressMsk);
        }
        return sb.toString();
    }

    public String toOrgString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._type.getValue()).append(SPACE_SEPARATOR);
        sb.append(this._flags).append(SPACE_SEPARATOR);
        sb.append(this._accessMsk).append(SPACE_SEPARATOR);
        sb.append(this._who.getValue()).append(SPACE_SEPARATOR);
        sb.append(this._whoID).append(SPACE_SEPARATOR);
        sb.append(this._addressMsk).append(SPACE_SEPARATOR);
        return sb.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(RsType rsType) {
        StringBuilder sb = new StringBuilder();
        sb.append("type = ").append((Object)this._type).append(", flags = ").append(AceFlags.asString(this._flags)).append(", accessMsk = ").append(AccessMask.asString(this._accessMsk, rsType)).append(", who = ").append((Object)this._who).append(", whoID = ").append(this._whoID);
        if (!this.isDefaultAddressMsk()) {
            sb.append(", addressMsk = ").append(this._addressMsk);
        }
        return sb.toString();
    }

    public String toExtraFormat(RsType rsType) throws ACLException {
        StringBuilder sb = new StringBuilder();
        sb.append(this._who.getAbbreviation());
        if (this._who == Who.USER || this._who == Who.GROUP) {
            sb.append(SEPARATOR).append(this._whoID);
        }
        sb.append(SEPARATOR);
        switch (this._type) {
            case ACCESS_ALLOWED_ACE_TYPE: {
                sb.append("+");
                break;
            }
            case ACCESS_DENIED_ACE_TYPE: {
                sb.append("-");
                break;
            }
            default: {
                throw new ACLException("Unsupported access type: " + (Object)((Object)this._type));
            }
        }
        sb.append(AccessMask.asString(this._accessMsk, rsType));
        if (this._flags != 0) {
            sb.append(SEPARATOR).append(AceFlags.asString(this._flags));
        }
        if (!this.isDefaultAddressMsk()) {
            sb.append(SEPARATOR).append(this._addressMsk);
        }
        return sb.toString();
    }
}

