/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.plugins;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.security.Principal;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.GroupNamePrincipal;
import org.dcache.auth.UidPrincipal;
import org.dcache.auth.UserNamePrincipal;
import org.dcache.auth.attributes.HomeDirectory;
import org.dcache.auth.attributes.ReadOnly;
import org.dcache.auth.attributes.RootDirectory;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.NoSuchPrincipalException;
import org.dcache.gplazma.plugins.GPlazmaIdentityPlugin;
import org.dcache.gplazma.plugins.GPlazmaMappingPlugin;
import org.dcache.gplazma.plugins.GPlazmaSessionPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ldap
implements GPlazmaIdentityPlugin,
GPlazmaSessionPlugin,
GPlazmaMappingPlugin {
    private static final Logger _log = LoggerFactory.getLogger(Ldap.class);
    private static final String GID_NUMBER_ATTRIBUTE = "gidNumber";
    private static final String HOME_DIR_ATTRIBUTE = "homeDirectory";
    private static final String UID_NUMBER_ATTRIBUTE = "uidNumber";
    private static final String COMMON_NAME_ATTRIBUTE = "cn";
    private static final String USER_ID_ATTRIBUTE = "uid";
    private static final String MEMBER_UID_ATTRIBUTE = "memberUid";
    static final String LDAP_SERVER = "gplazma.ldap.server";
    static final String LDAP_PORT = "gplazma.ldap.port";
    static final String LDAP_ORG = "gplazma.ldap.organization";
    static final String LDAP_PEOPLE_TREE = "gplazma.ldap.tree.people";
    static final String LDAP_GROUP_TREE = "gplazma.ldap.tree.groups";
    static final String LDAP_USER_FILTER = "gplazma.ldap.userfilter";
    private final String server;
    private final String port;
    private final String peopleOU;
    private final String groupOU;
    private final String userFilter;

    public Ldap(Properties properties) {
        this.server = properties.getProperty(LDAP_SERVER);
        this.port = properties.getProperty(LDAP_PORT);
        String organization = properties.getProperty(LDAP_ORG);
        String peopleTree = properties.getProperty(LDAP_PEOPLE_TREE);
        String groupTree = properties.getProperty(LDAP_GROUP_TREE);
        this.userFilter = properties.getProperty(LDAP_USER_FILTER);
        this.peopleOU = String.format("ou=%s,%s", peopleTree, organization);
        this.groupOU = String.format("ou=%s,%s", groupTree, organization);
    }

    public void map(Set<Principal> principals) throws AuthenticationException {
        Principal principal = (Principal)Iterables.find(principals, (Predicate)Predicates.instanceOf(UserNamePrincipal.class), null);
        if (principal != null) {
            try (ClosableContext ctx = new ClosableContext();){
                NamingEnumeration<SearchResult> sResult = ctx.get().search(this.peopleOU, String.format(this.userFilter, principal.getName()), this.getSimplSearchControls(UID_NUMBER_ATTRIBUTE, GID_NUMBER_ATTRIBUTE));
                if (sResult.hasMore()) {
                    Attributes userAttr = sResult.next().getAttributes();
                    principals.add((Principal)new UidPrincipal((String)userAttr.get(UID_NUMBER_ATTRIBUTE).get()));
                    principals.add((Principal)new GidPrincipal((String)userAttr.get(GID_NUMBER_ATTRIBUTE).get(), true));
                    NamingEnumeration<SearchResult> groupResult = ctx.get().search(this.groupOU, (Attributes)new BasicAttributes(MEMBER_UID_ATTRIBUTE, principal.getName()));
                    while (groupResult.hasMore()) {
                        SearchResult result = groupResult.next();
                        principals.add((Principal)new GidPrincipal((String)result.getAttributes().get(GID_NUMBER_ATTRIBUTE).get(), false));
                    }
                }
            }
            catch (NamingException e) {
                _log.warn("Failed to get mapping: {}", (Object)e.toString());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Principal map(Principal principal) throws NoSuchPrincipalException {
        String name = principal.getName();
        try (ClosableContext ctx = new ClosableContext();){
            NamingEnumeration<SearchResult> sResult;
            if (principal instanceof UserNamePrincipal) {
                sResult = ctx.get().search(this.peopleOU, String.format("(%s=%s)", USER_ID_ATTRIBUTE, name), this.getSimplSearchControls(UID_NUMBER_ATTRIBUTE));
                if (!sResult.hasMore()) throw new NoSuchPrincipalException(principal);
                SearchResult rs = sResult.next();
                UidPrincipal uidPrincipal = new UidPrincipal((String)rs.getAttributes().get(UID_NUMBER_ATTRIBUTE).get());
                return uidPrincipal;
            }
            if (!(principal instanceof GroupNamePrincipal)) throw new NoSuchPrincipalException(principal);
            sResult = ctx.get().search(this.groupOU, String.format("(%s=%s)", COMMON_NAME_ATTRIBUTE, name), this.getSimplSearchControls(GID_NUMBER_ATTRIBUTE));
            if (!sResult.hasMore()) throw new NoSuchPrincipalException(principal);
            SearchResult rs = sResult.next();
            GidPrincipal gidPrincipal = new GidPrincipal((String)rs.getAttributes().get(GID_NUMBER_ATTRIBUTE).get(), false);
            return gidPrincipal;
        }
        catch (NamingException e) {
            _log.warn("Failed to get mapping: {}", (Object)e.toString());
        }
        throw new NoSuchPrincipalException(principal);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<Principal> reverseMap(Principal principal) throws NoSuchPrincipalException {
        String id = principal.getName();
        try (ClosableContext ctx = new ClosableContext();){
            SearchResult result;
            NamingEnumeration<SearchResult> ne;
            HashSet<Principal> principals = new HashSet<Principal>();
            if (principal instanceof GidPrincipal) {
                ne = ctx.get().search(this.groupOU, (Attributes)new BasicAttributes(GID_NUMBER_ATTRIBUTE, id));
                while (ne.hasMore()) {
                    result = ne.next();
                    String name = (String)result.getAttributes().get(COMMON_NAME_ATTRIBUTE).get();
                    principals.add((Principal)new GroupNamePrincipal(name));
                }
            } else if (principal instanceof UidPrincipal) {
                ne = ctx.get().search(this.peopleOU, (Attributes)new BasicAttributes(UID_NUMBER_ATTRIBUTE, id));
                while (ne.hasMore()) {
                    result = ne.next();
                    String name = (String)result.getAttributes().get(USER_ID_ATTRIBUTE).get();
                    principals.add((Principal)new UserNamePrincipal(name));
                }
            }
            HashSet<Principal> hashSet = principals;
            return hashSet;
        }
        catch (NamingException e) {
            _log.warn("Failed to get reverse mapping: {}", (Object)e.toString());
            throw new NoSuchPrincipalException(principal);
        }
    }

    public void session(Set<Principal> authorizedPrincipals, Set<Object> attrib) throws AuthenticationException {
        Principal principal = (Principal)Iterables.find(authorizedPrincipals, (Predicate)Predicates.instanceOf(UserNamePrincipal.class), null);
        if (principal != null) {
            try (ClosableContext ctx = new ClosableContext();){
                NamingEnumeration<SearchResult> sResult = ctx.get().search(this.peopleOU, String.format(this.userFilter, principal.getName()), this.getSimplSearchControls(HOME_DIR_ATTRIBUTE));
                if (sResult.hasMore()) {
                    SearchResult rs = sResult.next();
                    attrib.add(new HomeDirectory((String)rs.getAttributes().get(HOME_DIR_ATTRIBUTE).get()));
                    attrib.add(new RootDirectory("/"));
                    attrib.add(new ReadOnly(false));
                }
            }
            catch (NamingException e) {
                throw new AuthenticationException("no mapping: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private SearchControls getSimplSearchControls(String ... attr) {
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        constraints.setReturningAttributes(attr);
        return constraints;
    }

    public static void main(String[] args) throws NamingException, AuthenticationException, NoSuchPrincipalException {
        Properties properties = new Properties();
        properties.setProperty(LDAP_SERVER, "seds2.desy.de");
        properties.setProperty(LDAP_PORT, "489");
        properties.setProperty(LDAP_ORG, "o=DESY,c=DE");
        properties.setProperty(LDAP_PEOPLE_TREE, "People");
        properties.setProperty(LDAP_GROUP_TREE, "PosixGroups");
        Ldap ldap = new Ldap(properties);
        System.out.println(ldap.map((Principal)new UserNamePrincipal("tigran")));
        try {
            ldap.map((Principal)new UserNamePrincipal("NoSuchUser"));
            System.out.println("huh!");
        }
        catch (NoSuchPrincipalException e) {
            System.out.println("No Such User");
        }
        System.out.println(ldap.map((Principal)new GroupNamePrincipal("it")));
        try {
            ldap.map((Principal)new GroupNamePrincipal("NoSuchGroup"));
            System.out.println("huh!");
        }
        catch (NoSuchPrincipalException e) {
            System.out.println("No Such Group");
        }
        System.out.println(ldap.reverseMap((Principal)new GidPrincipal(1000L, false)));
        System.out.println(ldap.reverseMap((Principal)new GidPrincipal(1070L, false)));
        System.out.println(ldap.reverseMap((Principal)new UidPrincipal(3750L)));
        System.out.println(ldap.reverseMap((Principal)new UidPrincipal(111111111L)));
        System.out.println(ldap.reverseMap((Principal)new GidPrincipal(222222222L, false)));
        HashSet<Principal> principals = new HashSet<Principal>();
        HashSet<Object> attrs = new HashSet<Object>();
        principals.add((Principal)new UserNamePrincipal("tigran"));
        ldap.map(principals);
        ldap.session(principals, attrs);
        System.out.println(principals);
        System.out.println(attrs);
    }

    private class ClosableContext
    implements AutoCloseable {
        private DirContext _ctx = this.newContext();

        public DirContext get() {
            return this._ctx;
        }

        @Override
        public void close() {
            try {
                if (this._ctx != null) {
                    this._ctx.close();
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }

        private DirContext newContext() throws NamingException {
            Properties env = new Properties();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", String.format("ldap://%s:%s", Ldap.this.server, Ldap.this.port));
            return new InitialLdapContext(env, null);
        }
    }
}

