/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.validation;

import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.UidPrincipal;
import org.dcache.auth.UserNamePrincipal;
import org.dcache.auth.attributes.HomeDirectory;
import org.dcache.auth.attributes.ReadOnly;
import org.dcache.auth.attributes.RootDirectory;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.LoginReply;
import org.dcache.gplazma.util.Preconditions;
import org.dcache.gplazma.validation.ValidationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoorValidationStrategy
implements ValidationStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DoorValidationStrategy.class);

    @Override
    public void validate(LoginReply loginReply) throws AuthenticationException {
        LOGGER.debug("Validating loginReply {}", (Object)loginReply);
        if (loginReply == null) {
            throw new NullPointerException("loginReply is null");
        }
        Set<Principal> principals = DoorValidationStrategy.getPrincipalsFromLoginReply(loginReply);
        DoorValidationStrategy.validatePrincipals(principals);
        Set<Object> attributes = DoorValidationStrategy.getSessionAttributesFromLoginReply(loginReply);
        DoorValidationStrategy.validateAttributes(attributes);
    }

    private static void validatePrincipals(Set<Principal> principals) throws AuthenticationException {
        boolean hasUserName = false;
        boolean hasUid = false;
        boolean hasPrimaryGid = false;
        for (Principal principal : principals) {
            GidPrincipal gidPrincipal;
            if (principal instanceof UserNamePrincipal) {
                Preconditions.checkAuthentication(!hasUserName, "multiple usernames");
                hasUserName = true;
                continue;
            }
            if (principal instanceof UidPrincipal) {
                Preconditions.checkAuthentication(!hasUid, "multiple UIDs");
                hasUid = true;
                continue;
            }
            if (!(principal instanceof GidPrincipal) || !(gidPrincipal = (GidPrincipal)principal).isPrimaryGroup()) continue;
            Preconditions.checkAuthentication(!hasPrimaryGid, "multiple GIDs");
            hasPrimaryGid = true;
        }
        Preconditions.checkAuthentication(hasUserName && hasUid && hasPrimaryGid, DoorValidationStrategy.principalsErrorMessage(hasUserName, hasUid, hasPrimaryGid));
    }

    private static String principalsErrorMessage(boolean hasUserName, boolean hasUid, boolean hasPrimaryGid) {
        StringBuilder errorMessage = new StringBuilder();
        if (!hasUserName) {
            errorMessage.append("no username");
        }
        if (!hasUid) {
            DoorValidationStrategy.appendWithComma(errorMessage, "no UID");
        }
        if (!hasPrimaryGid) {
            DoorValidationStrategy.appendWithComma(errorMessage, "no primary GID");
        }
        return errorMessage.toString();
    }

    private static void validateAttributes(Set<Object> attributes) throws AuthenticationException {
        boolean hasHome = false;
        boolean hasRoot = false;
        boolean hasReadOnly = false;
        for (Object attribute : attributes) {
            if (attribute instanceof HomeDirectory) {
                Preconditions.checkAuthentication(!hasHome, "multiple home-directories");
                hasHome = true;
            }
            if (attribute instanceof RootDirectory) {
                Preconditions.checkAuthentication(!hasRoot, "multiple root-directories");
                hasRoot = true;
            }
            if (!(attribute instanceof ReadOnly)) continue;
            Preconditions.checkAuthentication(!hasReadOnly, "multiple read-only declarations");
            hasReadOnly = true;
        }
        Preconditions.checkAuthentication(hasHome && hasRoot && hasReadOnly, DoorValidationStrategy.attributesErrorMessage(hasHome, hasRoot, hasReadOnly));
    }

    private static String attributesErrorMessage(boolean hasHome, boolean hasRoot, boolean hasReadOnly) {
        StringBuilder errorMsg = new StringBuilder();
        if (!hasHome) {
            errorMsg.append("no home-directory");
        }
        if (!hasRoot) {
            DoorValidationStrategy.appendWithComma(errorMsg, "no root-directory");
        }
        if (!hasReadOnly) {
            DoorValidationStrategy.appendWithComma(errorMsg, "no read-only declaration");
        }
        return errorMsg.toString();
    }

    private static StringBuilder appendWithComma(StringBuilder sb, String message) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        return sb.append(message);
    }

    private static Set<Object> getSessionAttributesFromLoginReply(LoginReply loginReply) throws AuthenticationException {
        Set<Object> attributes = loginReply.getSessionAttributes();
        Preconditions.checkAuthentication(attributes != null, "attributes is null");
        return attributes;
    }

    private static Set<Principal> getPrincipalsFromLoginReply(LoginReply loginReply) throws AuthenticationException {
        Subject subject = loginReply.getSubject();
        Preconditions.checkAuthentication(subject != null, "subject is null");
        Set<Principal> principals = subject.getPrincipals();
        Preconditions.checkAuthentication(principals != null, "subject principals is null");
        return principals;
    }
}

