/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.strategies;

import java.security.Principal;
import java.util.List;
import java.util.Set;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.monitor.LoginMonitor;
import org.dcache.gplazma.plugins.GPlazmaMappingPlugin;
import org.dcache.gplazma.strategies.GPlazmaPluginElement;
import org.dcache.gplazma.strategies.MappingStrategy;
import org.dcache.gplazma.strategies.PAMStyleStrategy;
import org.dcache.gplazma.strategies.PluginCaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMappingStrategy
implements MappingStrategy {
    private static final Logger logger = LoggerFactory.getLogger(DefaultMappingStrategy.class);
    private PAMStyleStrategy<GPlazmaMappingPlugin> pamStyleMappingStrategy;

    @Override
    public void setPlugins(List<GPlazmaPluginElement<GPlazmaMappingPlugin>> plugins) {
        this.pamStyleMappingStrategy = new PAMStyleStrategy(plugins);
    }

    @Override
    public synchronized void map(final LoginMonitor monitor, final Set<Principal> principals) throws AuthenticationException {
        this.pamStyleMappingStrategy.callPlugins(new PluginCaller<GPlazmaMappingPlugin>(){

            @Override
            public void call(GPlazmaPluginElement<GPlazmaMappingPlugin> pe) throws AuthenticationException {
                monitor.mapPluginBegins(pe.getName(), pe.getControl(), principals);
                GPlazmaMappingPlugin plugin = pe.getPlugin();
                LoginMonitor.Result result = LoginMonitor.Result.FAIL;
                String error = null;
                try {
                    plugin.map(principals);
                    result = LoginMonitor.Result.SUCCESS;
                }
                catch (AuthenticationException e) {
                    error = e.getMessage();
                    throw e;
                }
                finally {
                    monitor.mapPluginEnds(pe.getName(), pe.getControl(), result, error, principals);
                }
            }
        });
    }
}

