/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.strategies;

import java.security.Principal;
import java.util.List;
import java.util.Set;
import org.dcache.gplazma.AuthenticationException;
import org.dcache.gplazma.monitor.LoginMonitor;
import org.dcache.gplazma.plugins.GPlazmaAuthenticationPlugin;
import org.dcache.gplazma.strategies.AuthenticationStrategy;
import org.dcache.gplazma.strategies.GPlazmaPluginElement;
import org.dcache.gplazma.strategies.PAMStyleStrategy;
import org.dcache.gplazma.strategies.PluginCaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthenticationStrategy
implements AuthenticationStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuthenticationStrategy.class);
    private PAMStyleStrategy<GPlazmaAuthenticationPlugin> pamStyleAuthentiationStrategy;

    @Override
    public void setPlugins(List<GPlazmaPluginElement<GPlazmaAuthenticationPlugin>> plugins) {
        this.pamStyleAuthentiationStrategy = new PAMStyleStrategy(plugins);
    }

    @Override
    public synchronized void authenticate(final LoginMonitor monitor, final Set<Object> publicCredential, final Set<Object> privateCredential, final Set<Principal> identifiedPrincipals) throws AuthenticationException {
        this.pamStyleAuthentiationStrategy.callPlugins(new PluginCaller<GPlazmaAuthenticationPlugin>(){

            @Override
            public void call(GPlazmaPluginElement<GPlazmaAuthenticationPlugin> pe) throws AuthenticationException {
                monitor.authPluginBegins(pe.getName(), pe.getControl(), publicCredential, privateCredential, identifiedPrincipals);
                GPlazmaAuthenticationPlugin plugin = pe.getPlugin();
                LoginMonitor.Result result = LoginMonitor.Result.FAIL;
                String error = null;
                try {
                    plugin.authenticate(publicCredential, privateCredential, identifiedPrincipals);
                    result = LoginMonitor.Result.SUCCESS;
                }
                catch (AuthenticationException e) {
                    error = e.getMessage();
                    throw e;
                }
                finally {
                    monitor.authPluginEnds(pe.getName(), pe.getControl(), result, error, publicCredential, privateCredential, identifiedPrincipals);
                }
            }
        });
    }
}

