/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.monitor;

import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import org.dcache.gplazma.configuration.ConfigurationItemControl;
import org.dcache.gplazma.monitor.LoginMonitor;
import org.dcache.gplazma.monitor.LoginResult;

public class RecordingLoginMonitor
implements LoginMonitor {
    LoginResult _result = new LoginResult();
    private Set<Principal> _atPhaseStartPrincipals;
    private Set<Principal> _principals;
    private Set<Object> _publicCredentials;
    private Set<Object> _privateCredentials;

    @Override
    public void authBegins(Set<Object> publicCredentials, Set<Object> privateCredentials, Set<Principal> principals) {
        this._atPhaseStartPrincipals = new HashSet<Principal>(principals);
        LoginResult.AuthPhaseResult auth = this._result.getAuthPhase();
        auth.setPublicCredentials(publicCredentials);
        auth.setPrivateCredentials(privateCredentials);
    }

    @Override
    public void authPluginBegins(String name, ConfigurationItemControl control, Set<Object> publicCredentials, Set<Object> privateCredentials, Set<Principal> principals) {
        LoginResult.AuthPhaseResult auth = this._result.getAuthPhase();
        auth.addPluginResult(new LoginResult.AuthPluginResult(name, control));
        this._principals = new HashSet<Principal>(principals);
        this._publicCredentials = new HashSet<Object>(publicCredentials);
        this._privateCredentials = new HashSet<Object>(privateCredentials);
    }

    @Override
    public void authPluginEnds(String name, ConfigurationItemControl control, LoginMonitor.Result result, String error, Set<Object> publicCredentials, Set<Object> privateCredentials, Set<Principal> principals) {
        LoginResult.AuthPhaseResult auth = this._result.getAuthPhase();
        LoginResult.AuthPluginResult plugin = (LoginResult.AuthPluginResult)auth.getLastPlugin();
        plugin.setIdentified(this._principals, principals);
        plugin.setPublicCredentials(this._publicCredentials, publicCredentials);
        plugin.setPrivateCredentials(this._privateCredentials, privateCredentials);
        plugin.setResult(result);
        if (result == LoginMonitor.Result.FAIL) {
            plugin.setError(error);
        }
    }

    @Override
    public void authEnds(Set<Principal> principals, LoginMonitor.Result result) {
        LoginResult.AuthPhaseResult auth = this._result.getAuthPhase();
        auth.setPrincipals(this._atPhaseStartPrincipals, principals);
        auth.setResult(result);
    }

    @Override
    public void mapBegins(Set<Principal> principals) {
        this._atPhaseStartPrincipals = new HashSet<Principal>(principals);
    }

    @Override
    public void mapPluginBegins(String name, ConfigurationItemControl control, Set<Principal> principals) {
        LoginResult.MapPhaseResult map = this._result.getMapPhase();
        map.addPluginResult(new LoginResult.MapPluginResult(name, control));
        this._principals = new HashSet<Principal>(principals);
    }

    @Override
    public void mapPluginEnds(String name, ConfigurationItemControl control, LoginMonitor.Result result, String error, Set<Principal> principals) {
        LoginResult.MapPhaseResult map = this._result.getMapPhase();
        LoginResult.MapPluginResult plugin = (LoginResult.MapPluginResult)map.getLastPlugin();
        plugin.setResult(result);
        plugin.setPrincipals(this._principals, principals);
        if (result == LoginMonitor.Result.FAIL) {
            plugin.setError(error);
        }
    }

    @Override
    public void mapEnds(Set<Principal> principals, LoginMonitor.Result result) {
        LoginResult.MapPhaseResult map = this._result.getMapPhase();
        map.setPrincipals(this._atPhaseStartPrincipals, principals);
        map.setResult(result);
    }

    @Override
    public void accountBegins(Set<Principal> principals) {
        this._atPhaseStartPrincipals = new HashSet<Principal>(principals);
    }

    @Override
    public void accountPluginBegins(String name, ConfigurationItemControl control, Set<Principal> principals) {
        LoginResult.AccountPhaseResult account = this._result.getAccountPhase();
        account.addPluginResult(new LoginResult.AccountPluginResult(name, control));
        this._principals = new HashSet<Principal>(principals);
    }

    @Override
    public void accountPluginEnds(String name, ConfigurationItemControl control, LoginMonitor.Result result, String error, Set<Principal> principals) {
        LoginResult.AccountPhaseResult account = this._result.getAccountPhase();
        LoginResult.AccountPluginResult plugin = (LoginResult.AccountPluginResult)account.getLastPlugin();
        plugin.setAuthorized(this._principals, principals);
        plugin.setResult(result);
        if (result == LoginMonitor.Result.FAIL) {
            plugin.setError(error);
        }
    }

    @Override
    public void accountEnds(Set<Principal> principals, LoginMonitor.Result result) {
        LoginResult.AccountPhaseResult account = this._result.getAccountPhase();
        account.setPrincipals(this._atPhaseStartPrincipals, principals);
        account.setResult(result);
    }

    @Override
    public void sessionBegins(Set<Principal> principals) {
        this._atPhaseStartPrincipals = new HashSet<Principal>(principals);
    }

    @Override
    public void sessionPluginBegins(String name, ConfigurationItemControl control, Set<Principal> principals, Set<Object> attributes) {
        LoginResult.SessionPhaseResult session = this._result.getSessionPhase();
        session.addPluginResult(new LoginResult.SessionPluginResult(name, control));
        this._principals = new HashSet<Principal>(principals);
    }

    @Override
    public void sessionPluginEnds(String name, ConfigurationItemControl control, LoginMonitor.Result result, String error, Set<Principal> principals, Set<Object> attributes) {
        LoginResult.SessionPhaseResult session = this._result.getSessionPhase();
        LoginResult.SessionPluginResult plugin = (LoginResult.SessionPluginResult)session.getLastPlugin();
        plugin.setAuthorized(this._principals, principals);
        plugin.setAttributes(attributes);
        plugin.setResult(result);
        if (result == LoginMonitor.Result.FAIL) {
            plugin.setError(error);
        }
    }

    @Override
    public void sessionEnds(Set<Principal> principals, Set<Object> attributes, LoginMonitor.Result result) {
        LoginResult.SessionPhaseResult session = this._result.getSessionPhase();
        session.setPrincipals(this._atPhaseStartPrincipals, principals);
        session.setResult(result);
        session.setAttributes(attributes);
    }

    @Override
    public void validationResult(LoginMonitor.Result result, String error) {
        this._result.setValidationResult(result);
        if (result == LoginMonitor.Result.FAIL) {
            this._result.setValidationError(error);
        }
    }

    public LoginResult getResult() {
        return this._result;
    }
}

