/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.monitor;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dcache.gplazma.configuration.ConfigurationItemControl;
import org.dcache.gplazma.monitor.LoginMonitor;

public class LoginResult {
    private final AuthPhaseResult _authPhase = new AuthPhaseResult();
    private final MapPhaseResult _mapPhase = new MapPhaseResult();
    private final AccountPhaseResult _accountPhase = new AccountPhaseResult();
    private final SessionPhaseResult _sessionPhase = new SessionPhaseResult();
    private LoginMonitor.Result _validationResult;
    private String _validationError = "unknown";
    private boolean _validationHasHappened;

    public AuthPhaseResult getAuthPhase() {
        return this._authPhase;
    }

    public MapPhaseResult getMapPhase() {
        return this._mapPhase;
    }

    public AccountPhaseResult getAccountPhase() {
        return this._accountPhase;
    }

    public SessionPhaseResult getSessionPhase() {
        return this._sessionPhase;
    }

    public void setValidationResult(LoginMonitor.Result result) {
        this._validationHasHappened = true;
        this._validationResult = result;
    }

    public LoginMonitor.Result getValidationResult() {
        return this._validationResult;
    }

    public boolean hasValidationHappened() {
        return this._validationHasHappened;
    }

    public void setValidationError(String error) {
        this._validationError = error;
    }

    public String getValidationError() {
        Preconditions.checkState((this._validationResult == LoginMonitor.Result.FAIL ? 1 : 0) != 0, (Object)"Validation error is only valid if the plugin has failed");
        return this._validationError;
    }

    public boolean hasStarted() {
        return this.getAuthPhase().hasHappened();
    }

    public boolean hasCompleted() {
        return this.getSessionPhase().hasHappened();
    }

    public static class SessionPluginResult
    extends PAMPluginResult {
        private SetDiff<Principal> _principals;
        private Set<Object> _attributes;

        SessionPluginResult(String name, ConfigurationItemControl control) {
            super(name, control);
        }

        public void setAuthorized(Set<Principal> before, Set<Principal> after) {
            this._principals = new SetDiff<Principal>(before, after);
        }

        public SetDiff<Principal> getAuthorized() {
            return this._principals;
        }

        public void setAttributes(Set<Object> attributes) {
            this._attributes = new HashSet<Object>(attributes);
        }

        public Set<Object> getAttributes() {
            return this._attributes;
        }
    }

    public static class AccountPluginResult
    extends PAMPluginResult {
        private SetDiff<Principal> _authorized;

        AccountPluginResult(String name, ConfigurationItemControl control) {
            super(name, control);
        }

        void setAuthorized(Set<Principal> before, Set<Principal> after) {
            this._authorized = new SetDiff<Principal>(before, after);
        }

        public SetDiff<Principal> getAuthorized() {
            return this._authorized;
        }
    }

    public static class MapPluginResult
    extends PAMPluginResult {
        private SetDiff<Principal> _principals;

        MapPluginResult(String name, ConfigurationItemControl control) {
            super(name, control);
        }

        public void setPrincipals(Iterable<Principal> before, Iterable<Principal> after) {
            this._principals = new SetDiff<Principal>(before, after);
        }

        public SetDiff<Principal> getPrincipals() {
            return this._principals;
        }
    }

    public static class AuthPluginResult
    extends PAMPluginResult {
        private SetDiff<Principal> _identified;
        private SetDiff<Object> _publicCredentials;
        private SetDiff<Object> _privateCredentials;

        AuthPluginResult(String name, ConfigurationItemControl control) {
            super(name, control);
        }

        public void setIdentified(Set<Principal> before, Set<Principal> after) {
            this._identified = new SetDiff<Principal>(before, after);
        }

        public void setPublicCredentials(Set<Object> before, Set<Object> after) {
            this._publicCredentials = new SetDiff<Object>(before, after);
        }

        public void setPrivateCredentials(Set<Object> before, Set<Object> after) {
            this._privateCredentials = new SetDiff<Object>(before, after);
        }

        public SetDiff<Principal> getIdentified() {
            return this._identified;
        }

        public SetDiff<Object> getPublicCredentials() {
            return this._publicCredentials;
        }

        public SetDiff<Object> getPrivateCredentials() {
            return this._privateCredentials;
        }
    }

    public static class PAMPluginResult {
        private final String _name;
        private final ConfigurationItemControl _control;
        private LoginMonitor.Result _result;
        private String _error = "unknown";

        PAMPluginResult(String name, ConfigurationItemControl control) {
            this._name = name;
            this._control = control;
        }

        void setResult(LoginMonitor.Result result) {
            this._result = result;
        }

        void setError(String error) {
            this._error = error;
        }

        public String getName() {
            return this._name;
        }

        public ConfigurationItemControl getControl() {
            return this._control;
        }

        public LoginMonitor.Result getResult() {
            return this._result;
        }

        public String getError() {
            Preconditions.checkState((this._result == LoginMonitor.Result.FAIL ? 1 : 0) != 0, (Object)"error message only available if the plugin failed");
            return this._error;
        }
    }

    public static class SetDiff<T> {
        private final Set<T> _before;
        private final Set<T> _after;

        SetDiff(Iterable<T> before, Iterable<T> after) {
            this._before = Sets.newHashSet(before);
            this._after = Sets.newHashSet(after);
        }

        public Set<T> getBefore() {
            return this._before;
        }

        public Set<T> getAfter() {
            return this._after;
        }

        public Set<T> getAdded() {
            HashSet<T> added = new HashSet<T>(this._after);
            added.removeAll(this._before);
            return added;
        }

        public Set<T> getRemoved() {
            HashSet<T> removed = new HashSet<T>(this._before);
            removed.removeAll(this._after);
            return removed;
        }
    }

    public static class SessionPhaseResult
    extends PhaseResult<SessionPluginResult> {
        private final Set<Object> _attributes = new HashSet<Object>();

        public SessionPhaseResult() {
            super("SESSION");
        }

        void setAttributes(Set<Object> attributes) {
            this._attributes.clear();
            this._attributes.addAll(attributes);
        }

        public Set<Object> getAttributes() {
            return this._attributes;
        }
    }

    public static class AccountPhaseResult
    extends PhaseResult<AccountPluginResult> {
        public AccountPhaseResult() {
            super("ACCOUNT");
        }
    }

    public static class MapPhaseResult
    extends PhaseResult<MapPluginResult> {
        public MapPhaseResult() {
            super("MAP");
        }
    }

    public static class AuthPhaseResult
    extends PhaseResult<AuthPluginResult> {
        private final Set<Object> _publicCredentials = new HashSet<Object>();
        private final Set<Object> _privateCredentials = new HashSet<Object>();

        public AuthPhaseResult() {
            super("AUTH");
        }

        public void setPublicCredentials(Set<Object> publicCredentials) {
            this._publicCredentials.clear();
            this._publicCredentials.addAll(publicCredentials);
        }

        public void setPrivateCredentials(Set<Object> privateCredentials) {
            this._privateCredentials.clear();
            this._privateCredentials.addAll(privateCredentials);
        }

        public Set<Object> getPublicCredentials() {
            return this._publicCredentials;
        }

        public Set<Object> getPrivateCredentials() {
            return this._privateCredentials;
        }
    }

    public static class PhaseResult<T extends PAMPluginResult> {
        private final List<T> _plugins = new ArrayList<T>();
        private final String _name;
        private SetDiff<Principal> _principals;
        private LoginMonitor.Result _result;
        private boolean _hasHappened;

        public PhaseResult(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void addPluginResult(T result) {
            this._plugins.add(result);
        }

        public List<T> getPluginResults() {
            return this._plugins;
        }

        public boolean hasPlugins() {
            return !this._plugins.isEmpty();
        }

        public T getLastPlugin() {
            return (T)((PAMPluginResult)this._plugins.get(this._plugins.size() - 1));
        }

        public void setPrincipals(Set<Principal> before, Set<Principal> after) {
            this._principals = new SetDiff<Principal>(before, after);
        }

        public SetDiff<Principal> getPrincipals() {
            return this._principals;
        }

        public void setResult(LoginMonitor.Result result) {
            this._result = result;
            this._hasHappened = true;
        }

        public LoginMonitor.Result getResult() {
            return this._result;
        }

        public boolean hasHappened() {
            return this._hasHappened;
        }
    }
}

