/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.loader.cli;

import java.io.PrintStream;
import org.dcache.gplazma.loader.PluginMetadata;
import org.dcache.gplazma.loader.PluginRepository;
import org.dcache.gplazma.loader.PluginRepositoryFactory;
import org.dcache.gplazma.loader.XmlResourcePluginRepositoryFactory;
import org.dcache.gplazma.loader.cli.Command;

public class ListCommand
implements Command {
    private PluginRepositoryFactory _factory = new XmlResourcePluginRepositoryFactory();
    private PrintStream _out = System.out;

    @Override
    public int run(String[] args) {
        if (args.length > 1) {
            throw new IllegalArgumentException("List takes zero or one arguments");
        }
        if (args.length == 1 && !args[0].equals("-l")) {
            throw new IllegalArgumentException("Only -l is a valid argument");
        }
        PluginRepository.PluginMetadataProcessor listProcessor = args.length == 1 ? new DetailListPlugins() : new SimpleListPlugins();
        PluginRepository repository = this._factory.newRepository();
        repository.processPluginsWith(listProcessor);
        return 0;
    }

    @Override
    public void setFactory(PluginRepositoryFactory factory) {
        this._factory = factory;
    }

    @Override
    public void setOutput(PrintStream out) {
        this._out = out;
    }

    private class DetailListPlugins
    implements PluginRepository.PluginMetadataProcessor {
        private DetailListPlugins() {
        }

        @Override
        public void process(PluginMetadata plugin) {
            ListCommand.this._out.println("Plugin:");
            ListCommand.this._out.println("    Class: " + plugin.getPluginClass().getName());
            StringBuilder sb = new StringBuilder();
            sb.append("    Name: ");
            boolean isFirstName = true;
            for (String name : plugin.getPluginNames()) {
                if (!isFirstName) {
                    sb.append(",");
                }
                sb.append(name);
                isFirstName = false;
            }
            ListCommand.this._out.println(sb.toString());
            ListCommand.this._out.println("    Shortest name: " + plugin.getShortestName());
            if (plugin.getDefaultControl() != null) {
                ListCommand.this._out.println("    Default-control: " + plugin.getDefaultControl());
            }
        }
    }

    private class SimpleListPlugins
    implements PluginRepository.PluginMetadataProcessor {
        private SimpleListPlugins() {
        }

        @Override
        public void process(PluginMetadata plugin) {
            String shortestName = plugin.getShortestName();
            boolean firstAlias = true;
            StringBuilder sb = new StringBuilder();
            sb.append(shortestName);
            for (String name : plugin.getPluginNames()) {
                if (name.equals(shortestName)) continue;
                if (firstAlias) {
                    sb.append(" (");
                } else {
                    sb.append(",");
                }
                sb.append(name);
                firstAlias = false;
            }
            if (!firstAlias) {
                sb.append(")");
            }
            ListCommand.this._out.println(sb.toString());
        }
    }
}

