/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.dcache.gplazma.loader.PluginMetadata;
import org.dcache.gplazma.loader.PluginRepository;
import org.dcache.gplazma.loader.PluginRepositoryFactory;
import org.dcache.gplazma.loader.XmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlResourcePluginRepositoryFactory
implements PluginRepositoryFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlResourcePluginRepositoryFactory.class);
    public static final String RESOURCE_PATH = "META-INF/gplazma-plugins.xml";

    @Override
    public PluginRepository newRepository() {
        Set<URL> xmlResources = this.findXmlResources();
        PluginRepository repository = new PluginRepository();
        this.addPlugins(repository, xmlResources);
        return repository;
    }

    private Set<URL> findXmlResources() {
        HashSet<URL> results = new HashSet<URL>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> resources = classLoader.getResources(RESOURCE_PATH);
            while (resources.hasMoreElements()) {
                results.add(resources.nextElement());
            }
        }
        catch (IOException e) {
            LOGGER.error("Unable to locate plugin metadata", (Throwable)e);
        }
        return results;
    }

    private void addPlugins(PluginRepository repository, Set<URL> xmlResources) {
        for (URL xmlLocation : xmlResources) {
            this.tryAddingPluginsFromXml(repository, xmlLocation);
        }
    }

    private void tryAddingPluginsFromXml(PluginRepository repository, URL xmlLocation) {
        try {
            this.addPluginsFromXml(repository, xmlLocation);
        }
        catch (IOException e1) {
            LOGGER.error("Unable read XML data from {}", (Object)xmlLocation.toExternalForm());
        }
    }

    private void addPluginsFromXml(PluginRepository repository, URL xmlLocation) throws IOException {
        InputStream is = xmlLocation.openStream();
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        XmlParser parser = new XmlParser(in);
        parser.parse();
        for (PluginMetadata plugin : parser.getPlugins()) {
            repository.addPlugin(plugin);
        }
    }
}

