/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.loader;

import java.util.Collection;
import org.dcache.gplazma.loader.PluginMetadata;
import org.dcache.gplazma.loader.PluginRepository;
import org.dcache.gplazma.loader.PluginRepositoryFactory;
import org.dcache.gplazma.plugins.GPlazmaPlugin;

public class StaticClassPluginRepositoryFactory
implements PluginRepositoryFactory {
    private final Collection<Class<? extends GPlazmaPlugin>> _pluginClasses;

    public StaticClassPluginRepositoryFactory(Collection<Class<? extends GPlazmaPlugin>> plugins) {
        this._pluginClasses = plugins;
    }

    @Override
    public PluginRepository newRepository() {
        PluginRepository repository = new PluginRepository();
        for (Class<? extends GPlazmaPlugin> pluginClass : this._pluginClasses) {
            PluginMetadata pluginMetadata = new PluginMetadata();
            String pluginName = StaticClassPluginRepositoryFactory.getNameFromClass(pluginClass);
            pluginMetadata.addName(pluginName);
            pluginMetadata.setPluginClass(pluginClass);
            repository.addPlugin(pluginMetadata);
        }
        return repository;
    }

    protected static String getNameFromClass(Class<? extends GPlazmaPlugin> pluginClass) {
        return pluginClass.getSimpleName();
    }
}

