/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.loader;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.dcache.gplazma.loader.PluginFactory;
import org.dcache.gplazma.loader.PluginLoader;
import org.dcache.gplazma.loader.PluginLoadingException;
import org.dcache.gplazma.plugins.GPlazmaPlugin;

public class CachingPluginLoaderDecorator
implements PluginLoader {
    private final PluginLoader pluginLoader;
    private Map<String, GPlazmaPlugin> foundPlugins;

    public CachingPluginLoaderDecorator(PluginLoader pluginLoader) {
        this.pluginLoader = pluginLoader;
    }

    @Override
    public void setPluginFactory(PluginFactory factory) {
        this.pluginLoader.setPluginFactory(factory);
    }

    @Override
    public void init() {
        this.pluginLoader.init();
        this.foundPlugins = new HashMap<String, GPlazmaPlugin>();
    }

    @Override
    public GPlazmaPlugin newPluginByName(String name) throws PluginLoadingException {
        String key = name;
        GPlazmaPlugin plugin = this.foundPlugins.get(key);
        if (plugin != null) {
            return plugin;
        }
        plugin = this.pluginLoader.newPluginByName(name);
        this.foundPlugins.put(key, plugin);
        return plugin;
    }

    @Override
    public GPlazmaPlugin newPluginByName(String name, Properties properties) throws PluginLoadingException {
        String key = name;
        GPlazmaPlugin plugin = this.foundPlugins.get(key);
        if (plugin != null) {
            return plugin;
        }
        plugin = this.pluginLoader.newPluginByName(name, properties);
        this.foundPlugins.put(key, plugin);
        return plugin;
    }
}

