/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.configuration.parser;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.dcache.commons.util.Strings;
import org.dcache.gplazma.configuration.Configuration;
import org.dcache.gplazma.configuration.ConfigurationItem;
import org.dcache.gplazma.configuration.ConfigurationItemControl;
import org.dcache.gplazma.configuration.ConfigurationItemType;
import org.dcache.gplazma.configuration.parser.ConfigurationParser;
import org.dcache.gplazma.configuration.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PAMStyleConfigurationParser
implements ConfigurationParser {
    private static final Logger logger = LoggerFactory.getLogger(PAMStyleConfigurationParser.class);
    private static final int SPLIT_LIMIT = 4;
    private static final int MIN_SPLIT_RESULTS = 3;
    private static final String COMMENT_START = "#";

    @Override
    public Configuration parse(String configuration) throws ParseException {
        Preconditions.checkNotNull((Object)configuration, (Object)"Configuration must not be NULL");
        return this.parse(new BufferedReader(new StringReader(configuration)));
    }

    @Override
    public Configuration parse(File configurationFile) throws ParseException {
        Preconditions.checkNotNull((Object)configurationFile, (Object)"ConfigurationFile must not be NULL.");
        try {
            return this.parse(Files.newReader((File)configurationFile, (Charset)Charset.defaultCharset()));
        }
        catch (FileNotFoundException e) {
            throw new ParseException("GPlazma Configuration parsing failed", e);
        }
    }

    @Override
    public Configuration parse(BufferedReader bufferedReader) throws ParseException {
        ArrayList<ConfigurationItem> configItemList = new ArrayList<ConfigurationItem>();
        int offset = 0;
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                try {
                    ConfigurationItem configItem = this.parseLine(line);
                    if (configItem != null) {
                        configItemList.add(configItem);
                    }
                }
                catch (ParseException pe) {
                    pe.setOffset(offset);
                    throw pe;
                }
                ++offset;
            }
        }
        catch (IOException ioe) {
            throw new ParseException("GPlazma Configuration parsing failed", ioe, offset);
        }
        return new Configuration(configItemList);
    }

    private ConfigurationItem parseLine(String line) throws ParseException {
        String trimmed = line.trim();
        if (trimmed.isEmpty() || trimmed.startsWith(COMMENT_START)) {
            return null;
        }
        Object[] splitLine = trimmed.split("\\s+", 4);
        logger.debug("splitLine = " + Arrays.toString(splitLine));
        if (splitLine.length == 0) {
            return null;
        }
        if (splitLine.length < 3) {
            throw new ParseException("Syntax violation for line \"" + line + '\"');
        }
        try {
            ConfigurationItemType type = ConfigurationItemType.getConfigurationItemType((String)splitLine[0]);
            ConfigurationItemControl control = ConfigurationItemControl.getConfigurationItemControl((String)splitLine[1]);
            Object name = splitLine[2];
            Properties properties = new Properties();
            if (splitLine.length > 3) {
                String[] args;
                for (String arg : args = Strings.splitArgumentString((String)splitLine[3])) {
                    String[] kv = arg.split("=", 2);
                    if (kv.length != 2) continue;
                    properties.put(kv[0].trim(), kv[1].trim());
                }
            }
            return new ConfigurationItem(type, control, (String)name, properties);
        }
        catch (IllegalArgumentException iae) {
            throw new ParseException("Syntax violation for line \"" + line + '\"', iae);
        }
    }
}

