/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.gplazma.configuration;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.dcache.gplazma.configuration.Configuration;
import org.dcache.gplazma.configuration.ConfigurationLoadingStrategy;
import org.dcache.gplazma.configuration.parser.ConfigurationParser;
import org.dcache.gplazma.configuration.parser.ConfigurationParserFactory;
import org.dcache.gplazma.configuration.parser.FactoryConfigurationException;
import org.dcache.gplazma.configuration.parser.ParseException;

public class FromFileConfigurationLoadingStrategy
implements ConfigurationLoadingStrategy {
    private static final long CONFIGURATION_UPDATE_FREQUENCY_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private final File configurationFile;
    private long configurationFileLastModified;
    private long configurationFileLastChecked;

    public FromFileConfigurationLoadingStrategy(File configurationFile) {
        this.configurationFile = configurationFile;
    }

    public FromFileConfigurationLoadingStrategy(String configurationFileName) {
        this(new File(configurationFileName));
    }

    @Override
    public boolean hasUpdated() {
        if (System.currentTimeMillis() - this.configurationFileLastChecked < CONFIGURATION_UPDATE_FREQUENCY_MILLIS) {
            return false;
        }
        return this.configurationFileLastModified != this.configurationFile.lastModified();
    }

    @Override
    public Configuration load() throws ParseException, FactoryConfigurationException {
        this.configurationFileLastModified = this.configurationFile.lastModified();
        this.configurationFileLastChecked = System.currentTimeMillis();
        ConfigurationParserFactory parserFactory = ConfigurationParserFactory.getInstance();
        ConfigurationParser parser = parserFactory.newConfigurationParser();
        return parser.parse(this.configurationFile);
    }
}

