/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util.backoff;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import org.dcache.util.backoff.IBackoffAlgorithm;
import org.dcache.util.backoff.IBackoffAlgorithmFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackoffControllerBuilder {
    private final BackoffController controller = new BackoffController();

    public BackoffController build() {
        return this.controller;
    }

    public BackoffControllerBuilder using(IBackoffAlgorithmFactory algorithmFactory) {
        Preconditions.checkNotNull((Object)algorithmFactory);
        this.controller.algorithmFactory = algorithmFactory;
        return this;
    }

    public class BackoffController {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private IBackoffAlgorithmFactory algorithmFactory;

        private BackoffController() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IBackoffAlgorithm.Status call(Callable<IBackoffAlgorithm.Status> callable) throws Exception {
            IBackoffAlgorithm backoffAlgorithm = this.algorithmFactory.getAlgorithm();
            IBackoffAlgorithm.Status rval = IBackoffAlgorithm.Status.FAILURE;
            long wait = -1L;
            while ((rval = callable.call()) != IBackoffAlgorithm.Status.SUCCESS) {
                wait = backoffAlgorithm.getWaitDuration();
                if (wait == -1L) {
                    this.logger.debug("algorithm returned NO_WAIT");
                    break;
                }
                BackoffController backoffController = this;
                synchronized (backoffController) {
                    try {
                        this.wait(wait);
                    }
                    catch (InterruptedException e) {
                        this.logger.trace("wait was interrupted", (Throwable)e);
                    }
                }
            }
            return rval;
        }
    }
}

