/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.net.InetAddresses;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;

public abstract class NetworkUtils {
    private static final int RANDOM_PORT = 23241;
    private static final int FIRST_CLIENT_HOST = 0;
    private static final List<InetAddress> LOCAL_INET_ADDRESSES;
    private static final boolean FAKED_ADDRESS;
    public static final String LOCAL_HOST_ADDRESS_PROPERTY = "org.dcache.net.localaddresses";

    public static Comparator<InetAddress> getExternalInternalSorter() {
        return new Comparator<InetAddress>(){

            @Override
            public int compare(InetAddress arg0, InetAddress arg1) {
                if (arg0.isLinkLocalAddress() || arg0.isLoopbackAddress() || arg0.isSiteLocalAddress() || arg0.isMulticastAddress()) {
                    return 1;
                }
                return 0;
            }
        };
    }

    public static List<InetAddress> getLocalAddresses() {
        return LOCAL_INET_ADDRESSES;
    }

    public static List<InetAddress> getLocalAddressesV4() throws SocketException {
        return ImmutableList.copyOf((Collection)Collections2.filter(NetworkUtils.getLocalAddresses(), (Predicate)Predicates.instanceOf(Inet4Address.class)));
    }

    public static InetAddress getLocalAddressForClient(String[] clientHosts) throws SocketException, UnknownHostException {
        InetAddress clientAddress = InetAddress.getByName(clientHosts[0]);
        InetAddress localAddress = NetworkUtils.getLocalAddress(clientAddress);
        return localAddress;
    }

    public static InetAddress getLocalAddress(InetAddress intendedDestination) throws SocketException {
        if (FAKED_ADDRESS) {
            return LOCAL_INET_ADDRESSES.get(0);
        }
        try (DatagramSocket socket = new DatagramSocket();){
            socket.connect(intendedDestination, 23241);
            InetAddress localAddress = socket.getLocalAddress();
            if (localAddress.isAnyLocalAddress()) {
                if (intendedDestination.isLoopbackAddress()) {
                    localAddress = InetAddress.getLoopbackAddress();
                } else {
                    try {
                        localAddress = InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException e) {
                        localAddress = NetworkUtils.getLocalAddresses().get(0);
                    }
                }
            }
            InetAddress inetAddress = localAddress;
            return inetAddress;
        }
    }

    public static URL toURL(URI uri) throws URISyntaxException {
        try {
            return uri.toURL();
        }
        catch (IllegalArgumentException | MalformedURLException e) {
            URISyntaxException exception = new URISyntaxException(uri.toString(), e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }

    static {
        String localaddresses = System.getProperty(LOCAL_HOST_ADDRESS_PROPERTY);
        ArrayList<InetAddress> localInetAddress = new ArrayList<InetAddress>();
        if (localaddresses != null && !localaddresses.isEmpty()) {
            FAKED_ADDRESS = true;
            Splitter s = Splitter.on((char)',').omitEmptyStrings().trimResults();
            for (String address : s.split((CharSequence)localaddresses)) {
                localInetAddress.add(InetAddresses.forString((String)address));
            }
        } else {
            FAKED_ADDRESS = false;
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface i = interfaces.nextElement();
                    try {
                        if (!i.isUp() || i.isLoopback()) continue;
                        Enumeration<InetAddress> addresses = i.getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            localInetAddress.add(addresses.nextElement());
                        }
                    }
                    catch (SocketException e) {
                    }
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        LOCAL_INET_ADDRESSES = ImmutableList.copyOf(localInetAddress);
    }
}

