/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.util;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import diskCacheV111.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.dcache.util.Checksum;
import org.dcache.util.ChecksumType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Checksums {
    private static final Logger _log = LoggerFactory.getLogger(Checksums.class);
    private static final Splitter.MapSplitter RFC3230_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults().withKeyValueSeparator(Splitter.on((char)'=').limit(2));
    private static final Maps.EntryTransformer<String, String, Checksum> RFC3230_TO_CHECKSUM = new Maps.EntryTransformer<String, String, Checksum>(){

        public Checksum transformEntry(String type, String value) {
            try {
                switch (type.toLowerCase()) {
                    case "adler32": {
                        return new Checksum(ChecksumType.ADLER32, value);
                    }
                    case "md5": {
                        byte[] bytes = Base64.base64ToByteArray(value);
                        return new Checksum(ChecksumType.MD5_TYPE, bytes);
                    }
                }
                _log.debug("Unsupported checksum type {}", (Object)type);
                return null;
            }
            catch (IllegalArgumentException e) {
                _log.debug("Value \"{}\" is invalid for type {}", (Object)value, (Object)type);
                return null;
            }
        }
    };
    private static final Function<Checksum, String> FOR_RFC3230 = new Function<Checksum, String>(){

        public String apply(Checksum f) {
            byte[] bytes = f.getBytes();
            switch (f.getType()) {
                case ADLER32: {
                    return "adler32=" + Checksum.bytesToHexString(bytes);
                }
                case MD4_TYPE: {
                    return null;
                }
                case MD5_TYPE: {
                    return "md5=" + Base64.byteArrayToBase64(bytes);
                }
            }
            return null;
        }
    };

    private Checksums() {
    }

    public static String rfc3230Encoded(Collection<Checksum> checksums) {
        Collection rfc3230Parts = Collections2.transform(checksums, FOR_RFC3230);
        return Joiner.on((char)',').skipNulls().join((Iterable)rfc3230Parts);
    }

    public static Set<Checksum> rfc3230Decode(String digest) {
        Map parts = RFC3230_SPLITTER.split((CharSequence)Strings.nullToEmpty((String)digest));
        Map checksums = Maps.transformEntries((Map)parts, RFC3230_TO_CHECKSUM);
        return Sets.newHashSet((Iterable)Iterables.filter(checksums.values(), (Predicate)Predicates.notNull()));
    }
}

