/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.commons.stats;

import java.lang.management.ManagementFactory;
import java.util.Formatter;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.dcache.commons.stats.RequestExecutionTimeGaugeMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestExecutionTimeGaugeImpl
implements RequestExecutionTimeGaugeMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(RequestExecutionTimeGaugeImpl.class);
    private final String name;
    private long averageExecutionTime = 0L;
    private long minExecutionTime = 0L;
    private long maxExecutionTime = 0L;
    private long executionTimeRMSS = 0L;
    private int updateNum = 0;
    private long lastExecutionTime = 0L;
    private final long startTime;
    private long periodStartTime;
    private long periodAverageExecutionTime = 0L;
    private long periodUpdateNum = 0L;

    public RequestExecutionTimeGaugeImpl(String name, String family) {
        this.name = name;
        String mxName = String.format("%s:type=RequestExecutionTimeGauge,family=%s,name=%s", this.getClass().getPackage().getName(), family, this.name);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName mxBeanName = new ObjectName(mxName);
            if (!server.isRegistered(mxBeanName)) {
                server.registerMBean(this, mxBeanName);
            }
        }
        catch (MalformedObjectNameException ex) {
            LOG.warn("Failed to create a MXBean with name: {} : {}", (Object)mxName, (Object)ex.toString());
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException ex) {
            LOG.warn("Failed to register a MXBean: {}", (Object)ex.toString());
        }
        catch (NotCompliantMBeanException ex) {
            LOG.warn("Failed to create a MXBean: {}", (Object)ex.toString());
        }
        this.periodStartTime = this.startTime = System.currentTimeMillis();
    }

    @Override
    public synchronized void update(long nextExecTime) {
        if (nextExecTime < 0L) {
            LOG.info("possible backwards timeshift detected; discarding invalid data ({})", (Object)nextExecTime);
            return;
        }
        if (this.updateNum == 0) {
            this.averageExecutionTime = nextExecTime;
            this.minExecutionTime = nextExecTime;
            this.maxExecutionTime = nextExecTime;
            this.executionTimeRMSS = nextExecTime * nextExecTime;
        } else {
            this.averageExecutionTime = (this.averageExecutionTime * (long)this.updateNum + nextExecTime) / (long)(this.updateNum + 1);
            this.minExecutionTime = this.getMinExecutionTime() < nextExecTime ? this.getMinExecutionTime() : nextExecTime;
            this.maxExecutionTime = this.getMaxExecutionTime() > nextExecTime ? this.getMaxExecutionTime() : nextExecTime;
            this.executionTimeRMSS = (this.executionTimeRMSS * (long)this.updateNum + nextExecTime * nextExecTime) / (long)(this.updateNum + 1);
        }
        ++this.updateNum;
        this.periodAverageExecutionTime = (this.periodAverageExecutionTime * this.periodUpdateNum + nextExecTime) / (this.periodUpdateNum + 1L);
        ++this.periodUpdateNum;
        this.lastExecutionTime = nextExecTime;
    }

    @Override
    public synchronized long getAverageExecutionTime() {
        return this.averageExecutionTime;
    }

    @Override
    public synchronized long resetAndGetAverageExecutionTime() {
        long periodAverageExecutionTime = this.periodAverageExecutionTime;
        this.periodUpdateNum = 0L;
        this.periodAverageExecutionTime = this.lastExecutionTime;
        this.periodStartTime = System.currentTimeMillis();
        return periodAverageExecutionTime;
    }

    public synchronized String toString() {
        String aName = this.name;
        if (this.name.length() > 34) {
            aName = aName.substring(0, 34);
        }
        long updatePeriod = System.currentTimeMillis() - this.startTime;
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb);
        formatter.format("%-34s %12d\u00b1%10f %12d %12d %12d %12d %12d", aName, this.averageExecutionTime, this.getStandardError(), this.minExecutionTime, this.maxExecutionTime, this.getStandardDeviation(), this.updateNum, updatePeriod);
        formatter.flush();
        formatter.close();
        return sb.toString();
    }

    @Override
    public synchronized long getMinExecutionTime() {
        return this.minExecutionTime;
    }

    @Override
    public synchronized long getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized double getExecutionTimeRMS() {
        return Math.sqrt(this.executionTimeRMSS);
    }

    @Override
    public synchronized long getStandardDeviation() {
        long deviationSquare = this.executionTimeRMSS - this.averageExecutionTime * this.averageExecutionTime;
        assert (deviationSquare >= 0L);
        return (long)Math.sqrt(this.executionTimeRMSS - this.averageExecutionTime * this.averageExecutionTime);
    }

    @Override
    public synchronized double getStandardError() {
        return (double)this.getStandardDeviation() / Math.sqrt(this.updateNum);
    }

    @Override
    public synchronized int getUpdateNum() {
        return this.updateNum;
    }

    @Override
    public synchronized long getLastExecutionTime() {
        return this.lastExecutionTime;
    }

    @Override
    public synchronized long getStartTime() {
        return this.startTime;
    }

    @Override
    public synchronized long getPeriodStartTime() {
        return this.periodStartTime;
    }

    @Override
    public synchronized long getPeriodAverageExecutionTime() {
        return this.periodAverageExecutionTime;
    }

    @Override
    public synchronized long getPeriodUpdateNum() {
        return this.periodUpdateNum;
    }
}

