/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.dcache.auth.FQAN;
import org.dcache.auth.FQANPrincipal;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.LoginNamePrincipal;
import org.dcache.auth.Origin;
import org.dcache.auth.UidPrincipal;
import org.dcache.auth.UserAuthBase;
import org.dcache.auth.UserAuthRecord;
import org.dcache.auth.UserNamePrincipal;
import org.globus.gsi.jaas.GlobusPrincipal;

public class Subjects {
    public static final String UNKNOWN = "<unknown>";
    private static final Class<? extends Principal>[] DISPLAYABLE = new Class[]{UserNamePrincipal.class, GlobusPrincipal.class, KerberosPrincipal.class, Origin.class, Principal.class};
    public static final Subject ROOT = new Subject();
    public static final Subject NOBODY;

    public static boolean isRoot(Subject subject) {
        return Subjects.hasUid(subject, 0L);
    }

    public static boolean isNobody(Subject subject) {
        for (Principal principal : subject.getPrincipals()) {
            if (!(principal instanceof UidPrincipal)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasUid(Subject subject, long uid) {
        Set<UidPrincipal> principals = subject.getPrincipals(UidPrincipal.class);
        for (UidPrincipal principal : principals) {
            if (principal.getUid() != uid) continue;
            return true;
        }
        return false;
    }

    public static boolean hasGid(Subject subject, long gid) {
        Set<GidPrincipal> principals = subject.getPrincipals(GidPrincipal.class);
        for (GidPrincipal principal : principals) {
            if (principal.getGid() != gid) continue;
            return true;
        }
        return false;
    }

    public static long[] getUids(Subject subject) {
        Set<UidPrincipal> principals = subject.getPrincipals(UidPrincipal.class);
        long[] uids = new long[principals.size()];
        int i = 0;
        for (UidPrincipal principal : principals) {
            uids[i++] = principal.getUid();
        }
        return uids;
    }

    private static <T> T getUniquePrincipal(Subject subject, Class<T> type) throws IllegalArgumentException {
        T result = null;
        if (subject == null) {
            return null;
        }
        for (Principal principal : subject.getPrincipals()) {
            if (!type.isInstance(principal)) continue;
            if (result != null) {
                throw new IllegalArgumentException("Subject has multiple principals of type " + type.getSimpleName());
            }
            result = type.cast(principal);
        }
        return result;
    }

    public static long getUid(Subject subject) throws NoSuchElementException, IllegalArgumentException {
        UidPrincipal uid = Subjects.getUniquePrincipal(subject, UidPrincipal.class);
        if (uid == null) {
            throw new NoSuchElementException("Subject has no UID");
        }
        return uid.getUid();
    }

    public static long[] getGids(Subject subject) {
        Set<GidPrincipal> principals = subject.getPrincipals(GidPrincipal.class);
        long[] gids = new long[principals.size()];
        int i = 0;
        for (GidPrincipal principal : principals) {
            if (principal.isPrimaryGroup()) {
                gids[i++] = gids[0];
                gids[0] = principal.getGid();
                continue;
            }
            gids[i++] = principal.getGid();
        }
        return gids;
    }

    public static long getPrimaryGid(Subject subject) throws NoSuchElementException, IllegalArgumentException {
        Set<GidPrincipal> principals = subject.getPrincipals(GidPrincipal.class);
        int counter = 0;
        long gid = 0L;
        for (GidPrincipal principal : principals) {
            if (!principal.isPrimaryGroup()) continue;
            gid = principal.getGid();
            ++counter;
        }
        if (counter == 0) {
            throw new NoSuchElementException("Subject has no primary GID");
        }
        if (counter > 1) {
            throw new IllegalArgumentException("Subject has multiple primary GIDs");
        }
        return gid;
    }

    public static Origin getOrigin(Subject subject) throws IllegalArgumentException {
        return Subjects.getUniquePrincipal(subject, Origin.class);
    }

    public static String getDn(Subject subject) throws IllegalArgumentException {
        GlobusPrincipal principal = Subjects.getUniquePrincipal(subject, GlobusPrincipal.class);
        return principal == null ? null : principal.getName();
    }

    public static String getPrimaryFqan(Subject subject) throws NoSuchElementException {
        Set<FQANPrincipal> principals = subject.getPrincipals(FQANPrincipal.class);
        String fqan = null;
        for (FQANPrincipal principal : principals) {
            if (!principal.isPrimaryGroup()) continue;
            if (fqan != null) {
                throw new IllegalArgumentException("Subject has multiple primary FQANs");
            }
            fqan = principal.getName();
        }
        return fqan;
    }

    public static Collection<String> getFqans(Subject subject) {
        ArrayList<String> fqans = new ArrayList<String>();
        for (Principal principal : subject.getPrincipals()) {
            if (!(principal instanceof FQANPrincipal)) continue;
            fqans.add(principal.getName());
        }
        return fqans;
    }

    public static String getUserName(Subject subject) {
        UserNamePrincipal principal = Subjects.getUniquePrincipal(subject, UserNamePrincipal.class);
        return principal == null ? null : principal.getName();
    }

    public static String getLoginName(Subject subject) {
        LoginNamePrincipal principal = Subjects.getUniquePrincipal(subject, LoginNamePrincipal.class);
        return principal == null ? null : principal.getName();
    }

    public static String getDisplayName(Subject subject) {
        for (Class<? extends Principal> clazz : DISPLAYABLE) {
            Set<? extends Principal> principals = subject.getPrincipals(clazz);
            if (principals.isEmpty()) continue;
            return principals.iterator().next().getName();
        }
        return UNKNOWN;
    }

    public static final Subject getSubject(UserAuthBase user, boolean primary) {
        String fqan;
        String dn;
        Subject subject = new Subject();
        Set<Principal> principals = subject.getPrincipals();
        principals.add(new UidPrincipal(user.UID));
        principals.add(new GidPrincipal(user.GID, primary));
        String name = user.Username;
        if (name != null && !name.isEmpty()) {
            principals.add(new UserNamePrincipal(name));
        }
        if ((dn = user.DN) != null && !dn.isEmpty()) {
            principals.add(new GlobusPrincipal(dn));
        }
        if ((fqan = user.getFqan().toString()) != null && !fqan.isEmpty()) {
            principals.add(new FQANPrincipal(fqan, primary));
        }
        return subject;
    }

    public static final Subject getSubject(UserAuthRecord user) {
        String fqanstr;
        FQAN fqan;
        String dn;
        Subject subject = new Subject();
        Set<Principal> principals = subject.getPrincipals();
        principals.add(new UidPrincipal(user.UID));
        boolean primary = true;
        for (int gid : user.GIDs) {
            principals.add(new GidPrincipal(gid, primary));
            primary = false;
        }
        String name = user.Username;
        if (name != null && !name.isEmpty()) {
            principals.add(new UserNamePrincipal(name));
        }
        if ((dn = user.DN) != null && !dn.isEmpty()) {
            principals.add(new GlobusPrincipal(dn));
        }
        if ((fqan = user.getFqan()) != null && (fqanstr = fqan.toString()) != null && !fqanstr.isEmpty()) {
            principals.add(new FQANPrincipal(fqanstr, true));
        }
        return subject;
    }

    public static Subject of(int uid, int gid, int[] gids) {
        Subject subject = new Subject();
        subject.getPrincipals().add(new UidPrincipal(uid));
        subject.getPrincipals().add(new GidPrincipal(gid, true));
        for (int g : gids) {
            subject.getPrincipals().add(new GidPrincipal(g, false));
        }
        return subject;
    }

    public static Subject subjectFromArgs(List<String> args) {
        Set<Principal> principals = Subjects.principalsFromArgs(args);
        Set publicCredentials = Collections.emptySet();
        Set privateCredentials = Collections.emptySet();
        return new Subject(false, principals, publicCredentials, privateCredentials);
    }

    public static Set<Principal> principalsFromArgs(List<String> args) {
        HashSet<Principal> principals = new HashSet<Principal>();
        boolean isPrimaryFqan = true;
        for (String arg : args) {
            Principal principal;
            int idx = arg.indexOf(58);
            if (idx == -1) {
                throw new IllegalArgumentException("format for principals is <type>:<value>");
            }
            String type = arg.substring(0, idx);
            String value = arg.substring(idx + 1);
            switch (type) {
                case "dn": {
                    principal = new GlobusPrincipal(value);
                    break;
                }
                case "kerberos": {
                    principal = new KerberosPrincipal(value);
                    break;
                }
                case "fqan": {
                    principal = new FQANPrincipal(value, isPrimaryFqan);
                    isPrimaryFqan = false;
                    break;
                }
                case "name": {
                    principal = new LoginNamePrincipal(value);
                    break;
                }
                default: {
                    try {
                        Class<?> principalClass = Class.forName(type);
                        Constructor<?> principalConstructor = principalClass.getConstructor(String.class);
                        principal = (Principal)principalConstructor.newInstance(value);
                        break;
                    }
                    catch (NoSuchMethodException e) {
                        throw new IllegalArgumentException("No matching constructor found: " + type + "(String)");
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("No matching class found: " + type);
                    }
                    catch (InvocationTargetException e) {
                        throw new IllegalArgumentException("Invocation failed: " + e.toString());
                    }
                    catch (InstantiationException e) {
                        throw new IllegalArgumentException("Instantiation failed: " + e.toString());
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalArgumentException("Access Exception: " + e.toString());
                    }
                }
            }
            principals.add(principal);
        }
        return principals;
    }

    static {
        ROOT.getPrincipals().add(new UidPrincipal(0L));
        ROOT.getPrincipals().add(new GidPrincipal(0L, true));
        ROOT.setReadOnly();
        NOBODY = new Subject();
        NOBODY.setReadOnly();
    }
}

