/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import java.io.Serializable;
import org.dcache.auth.FQAN;
import org.dcache.auth.GroupPrincipal;

public class FQANPrincipal
implements GroupPrincipal,
Serializable {
    private static final long serialVersionUID = -4242349585261079835L;
    private FQAN _fqan;
    private boolean _isPrimary;

    public FQANPrincipal(String fqan) {
        this(fqan, false);
    }

    public FQANPrincipal(String fqan, boolean isPrimary) {
        this(new FQAN(fqan), isPrimary);
    }

    public FQANPrincipal(FQAN fqan, boolean isPrimary) {
        if (fqan == null) {
            throw new IllegalArgumentException("null value not allowed");
        }
        this._fqan = fqan;
        this._isPrimary = isPrimary;
    }

    @Override
    public boolean isPrimaryGroup() {
        return this._isPrimary;
    }

    @Override
    public boolean equals(Object another) {
        if (another == this) {
            return true;
        }
        if (!(another instanceof FQANPrincipal)) {
            return false;
        }
        FQANPrincipal other = (FQANPrincipal)another;
        return this._fqan.equals(other._fqan) && this._isPrimary == other._isPrimary;
    }

    @Override
    public String getName() {
        return this._fqan.toString();
    }

    public FQAN getFqan() {
        return this._fqan;
    }

    @Override
    public int hashCode() {
        return this._fqan.hashCode() ^ (this._isPrimary ? 1 : 0);
    }

    @Override
    public String toString() {
        if (this._isPrimary) {
            return FQANPrincipal.class.getSimpleName() + "[" + this._fqan + ",primary]";
        }
        return FQANPrincipal.class.getSimpleName() + "[" + this._fqan + "]";
    }
}

