/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import java.io.FileInputStream;
import java.security.MessageDigest;
import org.dcache.util.Checksum;

public class Adler32
extends MessageDigest {
    private static int BASE = 65521;
    private java.util.zip.Adler32 _zipAdler = new java.util.zip.Adler32();
    private long _adler = 1L;

    public Adler32() {
        super("ADLER32");
    }

    public void resetAdler32() {
        this._zipAdler.reset();
        this._adler = 1L;
    }

    public long updateAdler32(long adler, byte[] buf, int off, int len) {
        if (buf == null) {
            return 1L;
        }
        int s1 = (int)(adler & 0xFFFFL);
        int s2 = (int)(adler >> 16 & 0xFFFFL);
        for (int n = 0; n < len; ++n) {
            s1 = (s1 + (buf[off + n] & 0xFF)) % BASE;
            s2 = (s2 + s1) % BASE;
        }
        return (s2 << 16) + s1;
    }

    public long getAdler32() {
        return this._adler;
    }

    @Override
    public byte[] engineDigest() {
        return this.digestAdlerZip();
    }

    @Override
    public void engineReset() {
        this._zipAdler.reset();
    }

    @Override
    public void engineUpdate(byte input) {
        byte[] x = new byte[]{input};
        this._zipAdler.update(x, 0, 1);
    }

    @Override
    public void engineUpdate(byte[] data, int offset, int size) {
        this._zipAdler.update(data, offset, size);
    }

    @Override
    public int engineGetDigestLength() {
        return 4;
    }

    public byte[] digestAdler32() {
        byte[] _value = new byte[]{(byte)(this._adler >> 24 & 0xFFL), (byte)(this._adler >> 16 & 0xFFL), (byte)(this._adler >> 8 & 0xFFL), (byte)(this._adler & 0xFFL)};
        return _value;
    }

    public byte[] digestAdlerZip() {
        this._adler = this._zipAdler.getValue();
        byte[] _value = new byte[]{(byte)(this._adler >> 24 & 0xFFL), (byte)(this._adler >> 16 & 0xFFL), (byte)(this._adler >> 8 & 0xFFL), (byte)(this._adler & 0xFFL)};
        return _value;
    }

    public static void main(String[] args) throws Exception {
        int rc;
        if (args.length < 1) {
            System.err.println("Usage : ... <filename>");
            System.exit(4);
        }
        Adler32 adler = new Adler32();
        FileInputStream in = new FileInputStream(args[0]);
        byte[] buffer = new byte[1024];
        long sum = 0L;
        long started = System.currentTimeMillis();
        while ((rc = in.read(buffer, 0, buffer.length)) > 0) {
            sum += (long)rc;
            adler.update(buffer, 0, rc);
        }
        started = System.currentTimeMillis() - started;
        in.close();
        byte[] digest = adler.digest();
        System.out.println("Adler : (" + sum + ") " + Checksum.bytesToHexString(digest));
        System.out.println("Done in " + started + " milli seconds");
        System.exit(0);
    }
}

