/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Locale;
import org.freehep.util.DoubleWithError;

public class ScientificFormat
extends Format {
    private int sigDigit = 5;
    private int maxWidth = 8;
    private boolean sciNote = false;
    private DecimalFormat decimalFormat;
    private static final long serialVersionUID = -1182686857248711235L;
    private static final double k = 1.0 / Math.log(10.0);

    public ScientificFormat() {
    }

    public ScientificFormat(int sigDigit, int maxWidth, boolean SciNote) {
        this.setSigDigits(sigDigit);
        this.setMaxWidth(maxWidth);
        this.setScientificNotationStyle(SciNote);
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof Number) {
            String result = this.format(((Number)obj).doubleValue());
            return toAppendTo.append(result);
        }
        if (obj instanceof DoubleWithError) {
            DoubleWithError dwe = (DoubleWithError)obj;
            toAppendTo.append(this.format(dwe.getValue()));
            if (dwe.hasAsymmetricError()) {
                toAppendTo.append('+');
                int errorSigDigit = this.resolveErrorSigDigit(dwe.getValue(), dwe.getPlusError());
                toAppendTo.append(this.format(dwe.getPlusError(), errorSigDigit));
                toAppendTo.append('-');
                errorSigDigit = this.resolveErrorSigDigit(dwe.getValue(), dwe.getMinError());
                toAppendTo.append(this.format(dwe.getMinError(), errorSigDigit));
            } else {
                toAppendTo.append('\u00b1');
                int errorSigDigit = this.resolveErrorSigDigit(dwe.getValue(), dwe.getError());
                toAppendTo.append(this.format(dwe.getError(), errorSigDigit));
            }
            return toAppendTo;
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }

    public int getSigDigits() {
        return this.sigDigit;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public boolean getScientificNotationStyle() {
        return this.sciNote;
    }

    public void setSigDigits(int SigDigit) {
        if (SigDigit < 1) {
            throw new IllegalArgumentException("sigDigit");
        }
        this.sigDigit = SigDigit;
        this.decimalFormat = null;
    }

    public void setMaxWidth(int mWidth) {
        if (mWidth < 3) {
            throw new IllegalArgumentException("maxWidth");
        }
        this.maxWidth = mWidth;
    }

    public void setScientificNotationStyle(boolean sciNote) {
        this.sciNote = sciNote;
    }

    private double Log10(double x) {
        if (x == 0.0) {
            return 0.0;
        }
        return Math.log(x) * k;
    }

    private int resolveErrorSigDigit(double x, double dx) {
        dx = Math.abs(dx);
        x = Math.abs(x);
        if (dx == 0.0 || Double.isInfinite(dx) || Double.isNaN(dx) || dx >= x) {
            return this.sigDigit;
        }
        if (x == 0.0 || Double.isInfinite(x) || Double.isNaN(x)) {
            return this.sigDigit;
        }
        int log = (int)Math.round(this.Log10(dx / x));
        int errorsigdigit = this.sigDigit + log;
        if (errorsigdigit < 1) {
            return 1;
        }
        return errorsigdigit;
    }

    private DecimalFormat getDecimalFormat(int sigDig) {
        StringBuffer buffer = new StringBuffer("0.");
        for (int i = 1; i < sigDig; ++i) {
            buffer.append('0');
        }
        buffer.append("E0");
        return new DecimalFormat(buffer.toString(), new DecimalFormatSymbols(Locale.US));
    }

    public String format(double d) {
        return this.format(d, this.sigDigit);
    }

    private String format(double d, int sigDig) {
        if (Double.isInfinite(d)) {
            return this.maxWidth < 8 ? "INF" : "Infinite";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (this.decimalFormat == null) {
            this.decimalFormat = this.getDecimalFormat(this.sigDigit);
        }
        DecimalFormat format = sigDig == this.sigDigit ? this.decimalFormat : this.getDecimalFormat(sigDig);
        String preliminaryResult = format.format(d);
        if (this.sciNote) {
            return preliminaryResult;
        }
        int ePos = preliminaryResult.indexOf(69);
        int exponent = Integer.parseInt(preliminaryResult.substring(ePos + 1)) + 1;
        if (exponent > this.maxWidth) {
            return preliminaryResult;
        }
        if (exponent < -this.maxWidth + sigDig + 1) {
            return preliminaryResult;
        }
        int sign = preliminaryResult.charAt(0) == '-' ? 1 : 0;
        StringBuffer result = new StringBuffer(preliminaryResult.substring(sign, sign + 1) + preliminaryResult.substring(sign + 2, ePos));
        if (exponent >= sigDig) {
            for (int i = sigDig; i < exponent; ++i) {
                result.append('0');
            }
        } else if (exponent < 0) {
            result.insert(0, ".");
            for (int i = exponent; i < 0; ++i) {
                result.insert(1, '0');
            }
        } else {
            result.insert(exponent, '.');
        }
        if (sign > 0) {
            result.insert(0, '-');
        }
        return result.toString();
    }
}

