/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.dcache.xdr.GrizzlyMemoryManager;
import org.dcache.xdr.XdrDecodingStream;
import org.dcache.xdr.XdrEncodingStream;
import org.glassfish.grizzly.Buffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Xdr
implements XdrDecodingStream,
XdrEncodingStream {
    private static final int SIZE_OF_LONG = 8;
    private static final int SIZE_OF_INT = 4;
    public static final int MAX_XDR_SIZE = 524288;
    private static final Logger _log = LoggerFactory.getLogger(Xdr.class);
    protected volatile Buffer _buffer;
    private static final byte[] paddingZeros = new byte[]{0, 0, 0, 0};

    public Xdr(int size) {
        this(GrizzlyMemoryManager.allocate(size));
    }

    public Xdr(Buffer body) {
        this._buffer = body;
        this._buffer.order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public void beginDecoding() {
        this._buffer.rewind();
    }

    @Override
    public void endDecoding() {
        this._buffer.rewind();
    }

    @Override
    public void beginEncoding() {
        this._buffer.clear();
    }

    @Override
    public void endEncoding() {
        this._buffer.flip();
    }

    @Override
    public int xdrDecodeInt() {
        int val = this._buffer.getInt();
        _log.debug("Decoding int {}", (Object)val);
        return val;
    }

    @Override
    public int[] xdrDecodeIntVector() {
        int len = this.xdrDecodeInt();
        _log.debug("Decoding int array with len = {}", (Object)len);
        int[] ints = new int[len];
        for (int i = 0; i < len; ++i) {
            ints[i] = this.xdrDecodeInt();
        }
        return ints;
    }

    @Override
    public long[] xdrDecodeLongVector() {
        int len = this.xdrDecodeInt();
        _log.debug("Decoding long array with len = {}", (Object)len);
        long[] longs = new long[len];
        for (int i = 0; i < len; ++i) {
            longs[i] = this.xdrDecodeLong();
        }
        return longs;
    }

    @Override
    public float xdrDecodeFloat() {
        return Float.intBitsToFloat(this.xdrDecodeInt());
    }

    @Override
    public double xdrDecodeDouble() {
        return Double.longBitsToDouble(this.xdrDecodeLong());
    }

    @Override
    public double[] xdrDecodeDoubleVector() {
        int length = this.xdrDecodeInt();
        double[] value = new double[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeDouble();
        }
        return value;
    }

    @Override
    public double[] xdrDecodeDoubleFixedVector(int length) {
        double[] value = new double[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeDouble();
        }
        return value;
    }

    @Override
    public float[] xdrDecodeFloatVector() {
        int length = this.xdrDecodeInt();
        float[] value = new float[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeFloat();
        }
        return value;
    }

    @Override
    public float[] xdrDecodeFloatFixedVector(int length) {
        float[] value = new float[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeFloat();
        }
        return value;
    }

    @Override
    public void xdrDecodeOpaque(byte[] buf, int offset, int len) {
        int padding = 4 - (len & 3) & 3;
        _log.debug("padding zeros: {}", (Object)padding);
        this._buffer.get(buf, offset, len);
        this._buffer.position(this._buffer.position() + padding);
    }

    public void xdrDecodeOpaque(byte[] buf, int len) {
        this.xdrDecodeOpaque(buf, 0, len);
    }

    @Override
    public byte[] xdrDecodeOpaque(int len) {
        byte[] opaque = new byte[len];
        this.xdrDecodeOpaque(opaque, len);
        return opaque;
    }

    @Override
    public byte[] xdrDecodeDynamicOpaque() {
        int length = this.xdrDecodeInt();
        byte[] opaque = new byte[length];
        if (length != 0) {
            this.xdrDecodeOpaque(opaque, 0, length);
        }
        return opaque;
    }

    @Override
    public String xdrDecodeString() {
        String ret;
        int len = this.xdrDecodeInt();
        _log.debug("Decoding string with len = {}", (Object)len);
        if (len > 0) {
            byte[] bytes = new byte[len];
            this.xdrDecodeOpaque(bytes, 0, len);
            ret = new String(bytes);
        } else {
            ret = "";
        }
        return ret;
    }

    @Override
    public boolean xdrDecodeBoolean() {
        int bool = this.xdrDecodeInt();
        return bool != 0;
    }

    @Override
    public long xdrDecodeLong() {
        return this._buffer.getLong();
    }

    @Override
    public ByteBuffer xdrDecodeByteBuffer() {
        int len = this.xdrDecodeInt();
        int padding = 4 - (len & 3) & 3;
        ByteBuffer slice = this._buffer.toByteBuffer().slice();
        slice.rewind();
        slice.limit(len);
        this._buffer.position(this._buffer.position() + len + padding);
        return slice;
    }

    @Override
    public byte[] xdrDecodeByteVector() {
        int length = this.xdrDecodeInt();
        if (length > 0) {
            byte[] bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                bytes[i] = (byte)this.xdrDecodeInt();
            }
            return bytes;
        }
        return new byte[0];
    }

    @Override
    public byte[] xdrDecodeByteFixedVector(int length) {
        if (length > 0) {
            byte[] bytes = new byte[length];
            for (int i = 0; i < length; ++i) {
                bytes[i] = (byte)this.xdrDecodeInt();
            }
            return bytes;
        }
        return new byte[0];
    }

    @Override
    public byte xdrDecodeByte() {
        return (byte)this.xdrDecodeInt();
    }

    @Override
    public short xdrDecodeShort() {
        return (short)this.xdrDecodeInt();
    }

    @Override
    public short[] xdrDecodeShortVector() {
        int length = this.xdrDecodeInt();
        short[] value = new short[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeShort();
        }
        return value;
    }

    @Override
    public short[] xdrDecodeShortFixedVector(int length) {
        short[] value = new short[length];
        for (int i = 0; i < length; ++i) {
            value[i] = this.xdrDecodeShort();
        }
        return value;
    }

    @Override
    public void xdrEncodeInt(int value) {
        _log.debug("Encode int {}", (Object)value);
        this.ensureCapacity(4);
        this._buffer.putInt(value);
    }

    public Buffer asBuffer() {
        return this._buffer;
    }

    @Override
    public void xdrEncodeIntVector(int[] values) {
        _log.debug("Encode int array {}", (Object)Arrays.toString(values));
        this.ensureCapacity(4 + 4 * values.length);
        this._buffer.putInt(values.length);
        for (int value : values) {
            this._buffer.putInt(value);
        }
    }

    @Override
    public void xdrEncodeLongVector(long[] values) {
        _log.debug("Encode int array {}", (Object)Arrays.toString(values));
        this.ensureCapacity(4 + 8 * values.length);
        this._buffer.putInt(values.length);
        for (long value : values) {
            this._buffer.putLong(value);
        }
    }

    @Override
    public void xdrEncodeFloat(float value) {
        this.xdrEncodeInt(Float.floatToIntBits(value));
    }

    @Override
    public void xdrEncodeDouble(double value) {
        this.xdrEncodeLong(Double.doubleToLongBits(value));
    }

    @Override
    public void xdrEncodeFloatVector(float[] value) {
        int size = value.length;
        this.xdrEncodeInt(size);
        for (int i = 0; i < size; ++i) {
            this.xdrEncodeFloat(value[i]);
        }
    }

    @Override
    public void xdrEncodeFloatFixedVector(float[] value, int length) {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i = 0; i < length; ++i) {
            this.xdrEncodeFloat(value[i]);
        }
    }

    @Override
    public void xdrEncodeDoubleVector(double[] value) {
        int size = value.length;
        this.xdrEncodeInt(size);
        for (int i = 0; i < size; ++i) {
            this.xdrEncodeDouble(value[i]);
        }
    }

    @Override
    public void xdrEncodeDoubleFixedVector(double[] value, int length) {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i = 0; i < length; ++i) {
            this.xdrEncodeDouble(value[i]);
        }
    }

    @Override
    public void xdrEncodeString(String string) {
        _log.debug("Encode String:  {}", (Object)string);
        if (string == null) {
            string = "";
        }
        this.xdrEncodeDynamicOpaque(string.getBytes());
    }

    @Override
    public void xdrEncodeOpaque(byte[] bytes, int offset, int len) {
        _log.debug("Encode Opaque, len = {}", (Object)len);
        int padding = 4 - (len & 3) & 3;
        this.ensureCapacity(len + padding);
        this._buffer.put(bytes, offset, len);
        this._buffer.put(paddingZeros, 0, padding);
    }

    @Override
    public void xdrEncodeOpaque(byte[] bytes, int len) {
        this.xdrEncodeOpaque(bytes, 0, len);
    }

    @Override
    public void xdrEncodeDynamicOpaque(byte[] opaque) {
        this.xdrEncodeInt(opaque.length);
        this.xdrEncodeOpaque(opaque, 0, opaque.length);
    }

    @Override
    public void xdrEncodeBoolean(boolean bool) {
        this.xdrEncodeInt(bool ? 1 : 0);
    }

    @Override
    public void xdrEncodeLong(long value) {
        this.ensureCapacity(8);
        this._buffer.putLong(value);
    }

    @Override
    public void xdrEncodeByteBuffer(ByteBuffer buf) {
        buf.flip();
        int len = buf.remaining();
        int padding = 4 - (len & 3) & 3;
        this.xdrEncodeInt(len);
        this.ensureCapacity(len + padding);
        this._buffer.put(buf);
        this._buffer.position(this._buffer.position() + padding);
    }

    @Override
    public void xdrEncodeByteVector(byte[] value) {
        int length = value.length;
        this.xdrEncodeInt(length);
        if (length != 0) {
            for (int i = 0; i < length; ++i) {
                this.xdrEncodeInt(value[i]);
            }
        }
    }

    @Override
    public void xdrEncodeByteFixedVector(byte[] value, int length) {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        if (length != 0) {
            for (int i = 0; i < length; ++i) {
                this.xdrEncodeInt(value[i]);
            }
        }
    }

    @Override
    public void xdrEncodeByte(byte value) {
        this.xdrEncodeInt(value);
    }

    @Override
    public void xdrEncodeShort(short value) {
        this.xdrEncodeInt(value);
    }

    @Override
    public void xdrEncodeShortVector(short[] value) {
        int size = value.length;
        this.xdrEncodeInt(size);
        for (int i = 0; i < size; ++i) {
            this.xdrEncodeShort(value[i]);
        }
    }

    @Override
    public void xdrEncodeShortFixedVector(short[] value, int length) {
        if (value.length != length) {
            throw new IllegalArgumentException("array size does not match protocol specification");
        }
        for (int i = 0; i < length; ++i) {
            this.xdrEncodeShort(value[i]);
        }
    }

    public void close() {
        this._buffer.tryDispose();
    }

    private void ensureCapacity(int size) {
        if (this._buffer.remaining() < size) {
            int oldCapacity = this._buffer.capacity();
            int newCapacity = Math.max(oldCapacity * 3 / 2 + 1, oldCapacity + size);
            this._buffer = GrizzlyMemoryManager.reallocate(this._buffer, newCapacity);
        }
    }
}

