/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xdr;

import java.io.IOException;
import java.util.Map;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.OncRpcProgram;
import org.dcache.xdr.RpcCall;
import org.dcache.xdr.RpcDispatchable;
import org.dcache.xdr.RpcException;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcDispatcher
extends BaseFilter {
    private static final Logger _log = LoggerFactory.getLogger(RpcDispatcher.class);
    private final Map<OncRpcProgram, RpcDispatchable> _programs;

    public RpcDispatcher(Map<OncRpcProgram, RpcDispatchable> programs) throws NullPointerException {
        if (programs == null) {
            throw new NullPointerException("Programs is NULL");
        }
        this._programs = programs;
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        RpcCall call = (RpcCall)ctx.getMessage();
        int prog = call.getProgram();
        int vers = call.getProgramVersion();
        int proc = call.getProcedure();
        _log.debug("processing request {}", (Object)call);
        RpcDispatchable program = this._programs.get(new OncRpcProgram(prog, vers));
        if (program == null) {
            call.failProgramUnavailable();
        } else {
            try {
                program.dispatchOncRpcCall(call);
            }
            catch (RpcException e) {
                call.reject(e.getStatus(), e.getRpcReply());
                _log.error("Failed to process RPC request:", (Throwable)e);
            }
            catch (OncRpcException e) {
                _log.error("Failed to process RPC request:", (Throwable)e);
            }
        }
        return ctx.getInvokeAction();
    }
}

